/*
 * Decompiled with CFR 0.152.
 */
package com.mryarg1ch.storylineofmineyarg.utils;

import com.mryarg1ch.storylineofmineyarg.StorylineOfMineyarg;
import com.mryarg1ch.storylineofmineyarg.config.ApocalypseConfig;
import com.mryarg1ch.storylineofmineyarg.data.ApocalypseDataManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\b\b\u0002\u0010\u0012\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\rJ\u0010\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0006J\b\u0010\u0019\u001a\u00020\rH\u0002J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000b2\u0010\b\u0002\u0010\u001c\u001a\n\u0018\u00010\u001dj\u0004\u0018\u0001`\u001eJ\u000e\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u000bJ\u001e\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/mryarg1ch/storylineofmineyarg/utils/ApocalypseLogger;", "", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "isServerMode", "", "logFile", "Ljava/io/File;", "generateStatusReport", "", "", "initialize", "", "server", "Lnet/minecraft/server/MinecraftServer;", "logApocalypseEvent", "eventName", "details", "logApocalypsePause", "logApocalypseResume", "logApocalypseStart", "testMode", "logApocalypseStop", "resetProgress", "logCurrentProgress", "logError", "error", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logProgress", "message", "logSettingsChange", "settingName", "oldValue", "newValue", "storylineofmineyarg"})
public final class ApocalypseLogger {
    @NotNull
    public static final ApocalypseLogger INSTANCE = new ApocalypseLogger();
    @NotNull
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Nullable
    private static File logFile;
    private static boolean isServerMode;

    private ApocalypseLogger() {
    }

    public final void initialize(@Nullable MinecraftServer server) {
        if (!StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
            return;
        }
        boolean bl = isServerMode = server != null;
        if (isServerMode && server != null) {
            File logDir = new File(server.m_6237_(), "config/storylineofmineyarg/logs");
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            String logFileName = "apocalypse-" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + ".log";
            logFile = new File(logDir, logFileName);
            this.logProgress("=== \u041b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043e ===");
            this.logProgress("\u0420\u0435\u0436\u0438\u043c: \u0421\u0435\u0440\u0432\u0435\u0440");
            File file = logFile;
            Intrinsics.checkNotNull((Object)file);
            this.logProgress("\u0424\u0430\u0439\u043b \u043b\u043e\u0433\u0430: " + file.getAbsolutePath());
        } else {
            this.logProgress("=== \u041b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u043f\u043e\u043a\u0430\u043b\u0438\u043f\u0441\u0438\u0441\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043e ===");
            this.logProgress("\u0420\u0435\u0436\u0438\u043c: \u041e\u0434\u0438\u043d\u043e\u0447\u043d\u0430\u044f \u0438\u0433\u0440\u0430 (\u0442\u043e\u043b\u044c\u043a\u043e \u043a\u043e\u043d\u0441\u043e\u043b\u044c)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void logProgress(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!StorylineOfMineyarg.INSTANCE.getConfig().getEnableProgressLogging()) {
            return;
        }
        String timestamp = dateFormat.format(new Date());
        String logMessage = "[" + timestamp + "] [APOCALYPSE] " + message;
        System.out.println((Object)logMessage);
        if (isServerMode && logFile != null) {
            try {
                Closeable closeable = new FileWriter(logFile, true);
                Throwable throwable = null;
                try {
                    FileWriter writer = (FileWriter)closeable;
                    boolean bl = false;
                    Closeable closeable2 = new PrintWriter(writer);
                    Throwable throwable2 = null;
                    try {
                        PrintWriter printer = (PrintWriter)closeable2;
                        boolean bl2 = false;
                        printer.println(logMessage);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                System.err.println("[Storyline Of Mineyarg] ERROR: \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u043b\u043e\u0433 \u0444\u0430\u0439\u043b: " + e.getMessage());
            }
        }
    }

    public final void logApocalypseStart(boolean testMode) {
        this.logProgress("=== \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421 \u041d\u0410\u0427\u0410\u041b\u0421\u042f ===");
        this.logProgress("\u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c: " + (testMode ? "\u0414\u0410" : "\u041d\u0415\u0422"));
        this.logProgress("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438:");
        this.logProgress("  - \u0414\u043d\u0438 \u0434\u043e \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0430\u0432\u043d\u0430 \u0437\u043e\u043c\u0431\u0438: " + StorylineOfMineyarg.INSTANCE.getConfig().getDaysUntilMobSpawnIncrease());
        this.logProgress("  - \u0414\u043d\u0438 \u0434\u043e \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + StorylineOfMineyarg.INSTANCE.getConfig().getDaysUntilSnowfall());
        this.logProgress("  - \u0414\u043d\u0438 \u0434\u043e \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u0438 \u0437\u043e\u043c\u0431\u0438: " + StorylineOfMineyarg.INSTANCE.getConfig().getDaysUntilMobEvolution());
        this.logProgress("  - \u041a\u043e\u044d\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442 \u0441\u043f\u0430\u0432\u043d\u0430 \u0437\u043e\u043c\u0431\u0438: " + StorylineOfMineyarg.INSTANCE.getConfig().getMobSpawnCoefficient() + "%");
        this.logProgress("  - \u041a\u043e\u044d\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442 \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u0438 \u0437\u043e\u043c\u0431\u0438: " + StorylineOfMineyarg.INSTANCE.getConfig().getMobEvolutionSpeedCoefficient() + "%");
        this.logProgress("  - \u041a\u043e\u044d\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + StorylineOfMineyarg.INSTANCE.getConfig().getSnowfallSpeedCoefficient() + "%");
        BlockPos snowPos = StorylineOfMineyarg.INSTANCE.getConfig().getSnowSpawnPosition();
        if (snowPos != null) {
            this.logProgress("  - \u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + snowPos.m_123341_() + ", " + snowPos.m_123342_() + ", " + snowPos.m_123343_());
        } else {
            this.logProgress("  - \u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: \u041d\u0415 \u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d\u042b");
        }
    }

    public static /* synthetic */ void logApocalypseStart$default(ApocalypseLogger apocalypseLogger, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        apocalypseLogger.logApocalypseStart(bl);
    }

    public final void logApocalypseStop(boolean resetProgress) {
        this.logProgress("=== \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421 \u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d ===");
        this.logProgress("\u0421\u0431\u0440\u043e\u0441 \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441\u0430: " + (resetProgress ? "\u0414\u0410" : "\u041d\u0415\u0422"));
        if (!resetProgress) {
            this.logCurrentProgress();
        }
    }

    public final void logApocalypsePause() {
        this.logProgress("=== \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421 \u041f\u0420\u0418\u041e\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d ===");
        this.logCurrentProgress();
    }

    public final void logApocalypseResume() {
        this.logProgress("=== \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421 \u0412\u041e\u0417\u041e\u0411\u041d\u041e\u0412\u041b\u0415\u041d ===");
        this.logCurrentProgress();
    }

    public final void logApocalypseEvent(@NotNull String eventName, @NotNull String details) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.logProgress("\u0421\u041e\u0411\u042b\u0422\u0418\u0415: " + eventName);
        if (((CharSequence)details).length() > 0) {
            this.logProgress("  \u0414\u0435\u0442\u0430\u043b\u0438: " + details);
        }
        this.logCurrentProgress();
    }

    public static /* synthetic */ void logApocalypseEvent$default(ApocalypseLogger apocalypseLogger, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        apocalypseLogger.logApocalypseEvent(string, string2);
    }

    private final void logCurrentProgress() {
        ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
        long effectiveTime = dataManager.getEffectiveApocalypseTime();
        long hours = effectiveTime / (long)3600000;
        long minutes = effectiveTime % (long)3600000 / (long)60000;
        this.logProgress("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u0440\u043e\u0433\u0440\u0435\u0441\u0441:");
        this.logProgress("  - \u042d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + hours + "\u0447 " + minutes + "\u043c");
        this.logProgress("  - \u0423\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0430\u0432\u043d\u0430 \u0437\u043e\u043c\u0431\u0438: " + (dataManager.getMobSpawnIncreaseTriggered() ? "\u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d\u041e" : "\u041d\u0415 \u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d\u041e"));
        this.logProgress("  - \u0421\u043d\u0435\u0433\u043e\u043f\u0430\u0434: " + (dataManager.getSnowfallTriggered() ? "\u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d" : "\u041d\u0415 \u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d"));
        this.logProgress("  - \u0423\u0440\u043e\u0432\u0435\u043d\u044c \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u0438 \u0437\u043e\u043c\u0431\u0438: " + dataManager.getMobEvolutionLevel());
        this.logProgress("  - \u0420\u0430\u0434\u0438\u0443\u0441 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + dataManager.getCurrentSnowRadius() + " \u0431\u043b\u043e\u043a\u043e\u0432");
    }

    public final void logSettingsChange(@NotNull String settingName, @NotNull Object oldValue, @NotNull Object newValue) {
        Intrinsics.checkNotNullParameter((Object)settingName, (String)"settingName");
        Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        this.logProgress("\u0418\u0417\u041c\u0415\u041d\u0415\u041d\u0418\u0415 \u041d\u0410\u0421\u0422\u0420\u041e\u0415\u041a: " + settingName);
        this.logProgress("  \u0421\u0442\u0430\u0440\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: " + oldValue);
        this.logProgress("  \u041d\u043e\u0432\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: " + newValue);
    }

    public final void logError(@NotNull String error, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.logProgress("\u041e\u0428\u0418\u0411\u041a\u0410: " + error);
        if (exception != null) {
            this.logProgress("  \u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: " + exception.getClass().getSimpleName() + ": " + exception.getMessage());
        }
    }

    public static /* synthetic */ void logError$default(ApocalypseLogger apocalypseLogger, String string, Exception exception, int n, Object object) {
        if ((n & 2) != 0) {
            exception = null;
        }
        apocalypseLogger.logError(string, exception);
    }

    @NotNull
    public final List<String> generateStatusReport() {
        List report = new ArrayList();
        ApocalypseDataManager dataManager = StorylineOfMineyarg.INSTANCE.getDataManager();
        ApocalypseConfig config = StorylineOfMineyarg.INSTANCE.getConfig();
        report.add("=== \u041e\u0422\u0427\u0415\u0422 \u041e \u0421\u041e\u0421\u0422\u041e\u042f\u041d\u0418\u0418 \u0410\u041f\u041e\u041a\u0410\u041b\u0418\u041f\u0421\u0418\u0421\u0410 ===");
        report.add("\u0412\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f: " + dateFormat.format(new Date()));
        report.add("");
        report.add("\u0421\u041e\u0421\u0422\u041e\u042f\u041d\u0418\u0415:");
        report.add("  \u0410\u043a\u0442\u0438\u0432\u0435\u043d: " + (dataManager.isApocalypseActive() ? "\u0414\u0410" : "\u041d\u0415\u0422"));
        report.add("  \u041d\u0430 \u043f\u0430\u0443\u0437\u0435: " + (dataManager.isApocalypsePaused() ? "\u0414\u0410" : "\u041d\u0415\u0422"));
        report.add("  \u0422\u0435\u0441\u0442\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c: " + (dataManager.isTestMode() ? "\u0414\u0410" : "\u041d\u0415\u0422"));
        report.add("");
        if (dataManager.isApocalypseActive()) {
            long effectiveTime = dataManager.getEffectiveApocalypseTime();
            long hours = effectiveTime / (long)3600000;
            long minutes = effectiveTime % (long)3600000 / (long)60000;
            report.add("\u041f\u0420\u041e\u0413\u0420\u0415\u0421\u0421:");
            report.add("  \u042d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f: " + hours + "\u0447 " + minutes + "\u043c");
            report.add("  \u0423\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0430\u0432\u043d\u0430 \u0437\u043e\u043c\u0431\u0438: " + (dataManager.getMobSpawnIncreaseTriggered() ? "\u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d\u041e" : "\u041d\u0415 \u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d\u041e"));
            report.add("  \u0421\u043d\u0435\u0433\u043e\u043f\u0430\u0434: " + (dataManager.getSnowfallTriggered() ? "\u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d" : "\u041d\u0415 \u0410\u041a\u0422\u0418\u0412\u0418\u0420\u041e\u0412\u0410\u041d"));
            report.add("  \u0423\u0440\u043e\u0432\u0435\u043d\u044c \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u0438 \u0437\u043e\u043c\u0431\u0438: " + dataManager.getMobEvolutionLevel());
            report.add("  \u0420\u0430\u0434\u0438\u0443\u0441 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + dataManager.getCurrentSnowRadius() + " \u0431\u043b\u043e\u043a\u043e\u0432");
            report.add("");
        }
        report.add("\u041d\u0410\u0421\u0422\u0420\u041e\u0419\u041a\u0418:");
        report.add("  \u0414\u043d\u0438 \u0434\u043e \u0443\u0432\u0435\u043b\u0438\u0447\u0435\u043d\u0438\u044f \u0441\u043f\u0430\u0432\u043d\u0430 \u0437\u043e\u043c\u0431\u0438: " + config.getDaysUntilMobSpawnIncrease());
        report.add("  \u0414\u043d\u0438 \u0434\u043e \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + config.getDaysUntilSnowfall());
        report.add("  \u0414\u043d\u0438 \u0434\u043e \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u0438 \u0437\u043e\u043c\u0431\u0438: " + config.getDaysUntilMobEvolution());
        report.add("  \u041a\u043e\u044d\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442 \u0441\u043f\u0430\u0432\u043d\u0430 \u0437\u043e\u043c\u0431\u0438: " + config.getMobSpawnCoefficient() + "%");
        report.add("  \u041a\u043e\u044d\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442 \u044d\u0432\u043e\u043b\u044e\u0446\u0438\u0438 \u0437\u043e\u043c\u0431\u0438: " + config.getMobEvolutionSpeedCoefficient() + "%");
        report.add("  \u041a\u043e\u044d\u0444\u0444\u0438\u0446\u0438\u0435\u043d\u0442 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438 \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + config.getSnowfallSpeedCoefficient() + "%");
        report.add("  \u041b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435: " + (config.getEnableProgressLogging() ? "\u0412\u041a\u041b\u042e\u0427\u0415\u041d\u041e" : "\u0412\u042b\u041a\u041b\u042e\u0427\u0415\u041d\u041e"));
        BlockPos snowPos = config.getSnowSpawnPosition();
        if (snowPos != null) {
            report.add("  \u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: " + snowPos.m_123341_() + ", " + snowPos.m_123342_() + ", " + snowPos.m_123343_());
        } else {
            report.add("  \u041a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0441\u043d\u0435\u0433\u043e\u043f\u0430\u0434\u0430: \u041d\u0415 \u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041b\u0415\u041d\u042b");
        }
        report.add("");
        report.add("=== \u041a\u041e\u041d\u0415\u0426 \u041e\u0422\u0427\u0415\u0422\u0410 ===");
        return report;
    }
}

