/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamabnormals.woodworks.common.inventory.SawmillMenu;
import com.teamabnormals.woodworks.common.item.crafting.SawmillRecipe;
import com.teamabnormals.woodworks.core.Woodworks;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SawmillScreen
extends AbstractContainerScreen<SawmillMenu> {
    private static final ResourceLocation BG_LOCATION = Woodworks.location("textures/gui/container/sawmill.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;

    public SawmillScreen(SawmillMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        menu.registerUpdateListener(this::containerChanged);
        --this.titleLabelY;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float p_99329_, int p_99330_, int p_99331_) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_LOCATION);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(BG_LOCATION, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(41.0f * this.scrollOffs);
        guiGraphics.blit(BG_LOCATION, i + 119, j + 15 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.leftPos + 52;
        int i1 = this.topPos + 14;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, p_99330_, p_99331_, l, i1, j1);
        this.renderRecipes(guiGraphics, l, i1, j1);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int p_99334_, int p_99335_) {
        super.renderTooltip(guiGraphics, p_99334_, p_99335_);
        if (this.displayRecipes) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.startIndex + 12;
            List<RecipeHolder<SawmillRecipe>> list = ((SawmillMenu)this.menu).getRecipes();
            for (int l = this.startIndex; l < k && l < ((SawmillMenu)this.menu).getNumRecipes(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 16;
                int k1 = j + i1 / 4 * 18 + 2;
                if (p_99334_ < j1 || p_99334_ >= j1 + 16 || p_99335_ < k1 || p_99335_ >= k1 + 18) continue;
                guiGraphics.renderTooltip(this.font, ((SawmillRecipe)list.get(l).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), p_99334_, p_99335_);
            }
        }
    }

    private void renderButtons(GuiGraphics guiGraphics, int p_99343_, int p_99344_, int p_99345_, int p_99346_, int p_99347_) {
        for (int i = this.startIndex; i < p_99347_ && i < ((SawmillMenu)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = p_99345_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_99346_ + l * 18 + 2;
            int j1 = this.imageHeight;
            if (i == ((SawmillMenu)this.menu).getSelectedRecipeIndex()) {
                j1 += 18;
            } else if (p_99343_ >= k && p_99344_ >= i1 && p_99343_ < k + 16 && p_99344_ < i1 + 18) {
                j1 += 36;
            }
            guiGraphics.blit(BG_LOCATION, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int p_99349_, int p_99350_, int p_99351_) {
        List<RecipeHolder<SawmillRecipe>> list = ((SawmillMenu)this.menu).getRecipes();
        for (int i = this.startIndex; i < p_99351_ && i < ((SawmillMenu)this.menu).getNumRecipes(); ++i) {
            int j = i - this.startIndex;
            int k = p_99349_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_99350_ + l * 18 + 2;
            guiGraphics.renderItem(((SawmillRecipe)list.get(i).value()).getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()), k, i1);
        }
    }

    public boolean mouseClicked(double p_99318_, double p_99319_, int p_99320_) {
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.leftPos + 52;
            int j = this.topPos + 14;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int i1 = l - this.startIndex;
                double d0 = p_99318_ - (double)(i + i1 % 4 * 16);
                double d1 = p_99319_ - (double)(j + i1 / 4 * 18);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((SawmillMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l)) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((SawmillMenu)this.menu).containerId, l);
                return true;
            }
            i = this.leftPos + 119;
            j = this.topPos + 9;
            if (p_99318_ >= (double)i && p_99318_ < (double)(i + 12) && p_99319_ >= (double)j && p_99319_ < (double)(j + 54)) {
                this.scrolling = true;
            }
        }
        return super.mouseClicked(p_99318_, p_99319_, p_99320_);
    }

    public boolean mouseDragged(double p_99322_, double p_99323_, int p_99324_, double p_99325_, double p_99326_) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 14;
            int j = i + 54;
            this.scrollOffs = ((float)p_99323_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(p_99322_, p_99323_, p_99324_, p_99325_, p_99326_);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)scrollY / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((SawmillMenu)this.menu).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((SawmillMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((SawmillMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
    }
}

