/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamabnormals.blueprint.client.BlueprintChestMaterials;
import com.teamabnormals.blueprint.client.renderer.block.BlueprintChestBlockEntityRenderer;
import com.teamabnormals.blueprint.core.api.IChestBlock;
import com.teamabnormals.woodworks.common.block.ClosetBlock;
import com.teamabnormals.woodworks.core.other.WoodworksModelLayers;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DrawerBlockEntityRenderer<T extends BlockEntity>
extends BlueprintChestBlockEntityRenderer<T> {
    public static Block itemBlock = null;
    private final ModelPart leftDoor;
    private final ModelPart leftBack;
    private final ModelPart tallLeftDoor;
    private final ModelPart tallLeftBack;
    private final ModelPart rightDoor;
    private final ModelPart rightBack;
    private final ModelPart tallRightDoor;
    private final ModelPart tallRightBack;

    public DrawerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        ModelPart left = context.bakeLayer(WoodworksModelLayers.BAMBOO_CLOSET_LEFT);
        this.leftBack = left.getChild("back");
        this.leftDoor = left.getChild("door");
        ModelPart tallLeft = context.bakeLayer(WoodworksModelLayers.BAMBOO_CLOSET_TALL_LEFT);
        this.tallLeftBack = tallLeft.getChild("back");
        this.tallLeftDoor = tallLeft.getChild("door");
        ModelPart right = context.bakeLayer(WoodworksModelLayers.BAMBOO_CLOSET_RIGHT);
        this.rightBack = right.getChild("back");
        this.rightDoor = right.getChild("door");
        ModelPart tallRight = context.bakeLayer(WoodworksModelLayers.BAMBOO_CLOSET_TALL_RIGHT);
        this.tallRightBack = tallRight.getChild("back");
        this.tallRightDoor = tallRight.getChild("door");
    }

    public static LayerDefinition createBodyLayer(boolean tall, boolean mirror) {
        float height = tall ? 16.0f : 14.0f;
        float pivot = mirror ? 15.0f : 1.0f;
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition back = partdefinition.addOrReplaceChild("back", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 1.0f, 14.0f, height, 11.0f, mirror), PartPose.ZERO);
        PartDefinition door = partdefinition.addOrReplaceChild("door", CubeListBuilder.create().texOffs(0, tall ? 27 : 25).addBox(-pivot + 1.0f, 0.0f, 0.0f, 14.0f, height, 4.0f, mirror), PartPose.offset((float)pivot, (float)0.0f, (float)11.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(T tileEntityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Level level = tileEntityIn.getLevel();
        boolean flag = level != null;
        BlockState state = flag ? tileEntityIn.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chesttype = state.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)state.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        Block block = state.getBlock();
        if (block instanceof AbstractChestBlock) {
            boolean right;
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            poseStack.pushPose();
            Direction facing = (Direction)state.getValue((Property)ChestBlock.FACING);
            float f = facing.toYRot();
            boolean bl = right = state.hasProperty(ClosetBlock.HINGE) && state.getValue(ClosetBlock.HINGE) == DoorHingeSide.RIGHT;
            if (flag && ClosetBlock.shouldTranslateCloset(state, (BlockGetter)level, tileEntityIn.getBlockPos())) {
                poseStack.translate((double)facing.getNormal().getZ() * 0.0625 * (right ? -1.0 : 1.0), 0.0, (double)(-facing.getNormal().getX()) * 0.0625 * (right ? -1.0 : 1.0));
            }
            poseStack.translate(0.5, 0.5, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(-f));
            poseStack.translate(-0.5, -0.5, -0.5);
            DoubleBlockCombiner.NeighborCombineResult icallbackwrapper = flag ? abstractchestblock.combine(state, level, tileEntityIn.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float f1 = ((Float2FloatFunction)icallbackwrapper.apply(ChestBlock.opennessCombiner((LidBlockEntity)((LidBlockEntity)tileEntityIn)))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            if (right) {
                f1 *= -1.0f;
            }
            int i = ((Int2IntFunction)icallbackwrapper.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(combinedLightIn);
            VertexConsumer ivertexbuilder = this.getChestMaterial(tileEntityIn, chesttype).buffer(bufferIn, RenderType::entityCutout);
            if (flag1 && chesttype == ChestType.RIGHT) {
                this.render(poseStack, ivertexbuilder, right ? this.tallRightDoor : this.tallLeftDoor, right ? this.tallRightBack : this.tallLeftBack, f1, i, combinedOverlayIn);
            } else {
                this.render(poseStack, ivertexbuilder, right ? this.rightDoor : this.leftDoor, right ? this.rightBack : this.leftBack, f1, i, combinedOverlayIn);
            }
            poseStack.popPose();
        }
    }

    public Material getChestMaterial(T t, ChestType type) {
        Block inventoryBlock = itemBlock;
        if (inventoryBlock == null) {
            inventoryBlock = t.getBlockState().getBlock();
        }
        BlueprintChestMaterials.ChestMaterials chestMaterials = BlueprintChestMaterials.getMaterials((String)((IChestBlock)inventoryBlock).getChestMaterialsName());
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ChestType.SINGLE -> {
                if (chestMaterials != null) {
                    yield chestMaterials.singleMaterial();
                }
                yield Sheets.CHEST_LOCATION;
            }
            case ChestType.LEFT -> {
                if (chestMaterials != null) {
                    yield chestMaterials.leftMaterial();
                }
                yield Sheets.CHEST_LOCATION_LEFT;
            }
            case ChestType.RIGHT -> chestMaterials != null ? chestMaterials.rightMaterial() : Sheets.CHEST_LOCATION_RIGHT;
        };
    }

    public void render(PoseStack matrixStack, VertexConsumer builder, ModelPart closetDoor, ModelPart closetBack, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        closetDoor.yRot = -(lidAngle * 1.701696f);
        closetDoor.render(matrixStack, builder, combinedLightIn, combinedOverlayIn);
        closetBack.render(matrixStack, builder, combinedLightIn, combinedOverlayIn);
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos worldPos = blockEntity.getBlockPos();
        int x = worldPos.getX();
        int y = worldPos.getY();
        int z = worldPos.getZ();
        return new AABB((double)(x - 1), (double)y, (double)(z - 1), (double)(x + 2), (double)(y + 2), (double)(z + 2));
    }
}

