/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.common;

import com.teamabnormals.woodworks.core.registry.WoodworksRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WoodenChestRecipe
extends CustomRecipe {
    public WoodenChestRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.width() == 3 && input.height() == 3) {
            for (int i = 0; i < input.height(); ++i) {
                for (int j = 0; j < input.width(); ++j) {
                    ItemStack stack = input.getItem(j, i);
                    if (!(j == 1 && i == 1 ? !stack.isEmpty() : !stack.is(ItemTags.PLANKS))) continue;
                    return false;
                }
            }
            return level.getRecipeManager().getRecipes().stream().map(RecipeHolder::value).filter(recipe -> recipe.getType() == RecipeType.CRAFTING && !recipe.isSpecial()).map(recipe -> (CraftingRecipe)recipe).filter(recipe -> recipe.matches((RecipeInput)input, level)).toList().isEmpty();
        }
        return false;
    }

    public ItemStack assemble(CraftingInput container, HolderLookup.Provider registries) {
        return new ItemStack((ItemLike)Items.CHEST);
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x == 3 && y == 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)WoodworksRecipes.WoodworksRecipeSerializers.WOODEN_CHEST.get();
    }
}

