/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.common.block;

import com.teamabnormals.blueprint.core.api.IChestBlock;
import com.teamabnormals.woodworks.common.block.entity.ClosetBlockEntity;
import com.teamabnormals.woodworks.core.registry.WoodworksBlockEntityTypes;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClosetBlock
extends ChestBlock
implements IChestBlock {
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;
    protected static final VoxelShape NORTH_AABB = Block.box((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0);
    protected static final VoxelShape NORTH_AABB_TALL = Block.box((double)2.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SOUTH_AABB_TALL = Block.box((double)0.0, (double)0.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)14.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WEST_AABB_TALL = Block.box((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB_TALL = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)14.0);
    protected static final VoxelShape AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    protected static final VoxelShape AABB_TALL = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public final String type;
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity chest1, final ChestBlockEntity chest2) {
            CompoundContainer container = new CompoundContainer((Container)chest2, (Container)chest1);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$container;
                {
                    this.val$container = container;
                }

                @Nullable
                public AbstractContainerMenu createMenu(int num, Inventory inventory, Player player) {
                    if (chest1.canOpen(player) && chest2.canOpen(player)) {
                        chest1.unpackLootTable(inventory.player);
                        chest2.unpackLootTable(inventory.player);
                        return ChestMenu.sixRows((int)num, (Inventory)inventory, (Container)this.val$container);
                    }
                    return null;
                }

                public Component getDisplayName() {
                    if (chest1.hasCustomName()) {
                        return chest1.getDisplayName();
                    }
                    return chest2.hasCustomName() ? chest2.getDisplayName() : Component.translatable((String)"container.woodworks.closetDouble");
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity p_51602_) {
            return Optional.of(p_51602_);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    public ClosetBlock(String type, BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType) {
        super(props, blockEntityType);
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HINGE, (Comparable)DoorHingeSide.LEFT)).setValue((Property)TYPE, (Comparable)ChestType.SINGLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ClosetBlock(String type, BlockBehaviour.Properties props) {
        this(type, props, () -> WoodworksBlockEntityTypes.CLOSET.get());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ClosetBlockEntity(pos, state);
    }

    public String getChestMaterialsName() {
        return this.type;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return ((Optional)this.combine(state, level, pos, false).apply(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> combine(BlockState state, Level level, BlockPos pos, boolean p_51547_) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = p_51547_ ? (p_51578_, p_51579_) -> false : ClosetBlock::isChestBlockedAt;
        return DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)this.blockEntityType.get()), ChestBlock::getBlockType, ClosetBlock::getConnectedDirection, (DirectionProperty)FACING, (BlockState)state, (LevelAccessor)level, (BlockPos)pos, bipredicate);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean left;
        boolean tall = state.getValue((Property)TYPE) == ChestType.RIGHT;
        boolean bl = left = state.getValue(HINGE) == DoorHingeSide.LEFT;
        if (ClosetBlock.shouldTranslateCloset(state, level, pos)) {
            VoxelShape north = tall ? NORTH_AABB_TALL : NORTH_AABB;
            VoxelShape south = tall ? SOUTH_AABB_TALL : SOUTH_AABB;
            VoxelShape east = tall ? EAST_AABB_TALL : EAST_AABB;
            VoxelShape west = tall ? WEST_AABB_TALL : WEST_AABB;
            switch ((Direction)state.getValue((Property)FACING)) {
                default: {
                    return !left ? north : south;
                }
                case SOUTH: {
                    return !left ? south : north;
                }
                case WEST: {
                    return left ? west : east;
                }
                case EAST: 
            }
            return left ? east : west;
        }
        if (tall) {
            return AABB_TALL;
        }
        return AABB;
    }

    public static boolean shouldTranslateCloset(BlockState state, BlockGetter level, BlockPos pos) {
        ChestType chesttype;
        boolean right = state.hasProperty(HINGE) && state.getValue(HINGE) == DoorHingeSide.RIGHT;
        Direction facing = (Direction)state.getValue((Property)ChestBlock.FACING);
        BlockPos neighborPos = pos.relative(!right ? facing.getCounterClockWise() : facing.getClockWise());
        ChestType chestType = chesttype = state.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)state.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        if (level.getBlockState(neighborPos).is(state.getBlock())) {
            BlockState neighborState = level.getBlockState(neighborPos);
            DoorHingeSide hinge = (DoorHingeSide)state.getValue(HINGE);
            return neighborState.getValue((Property)TYPE) == chesttype && neighborState.getValue((Property)FACING) == facing && neighborState.getValue(HINGE) != hinge;
        }
        return false;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (otherState.is((Block)this) && direction.getAxis().isVertical()) {
            ChestType chesttype = (ChestType)otherState.getValue((Property)TYPE);
            if (state.getValue((Property)TYPE) == ChestType.SINGLE && chesttype != ChestType.SINGLE && state.getValue((Property)FACING) == otherState.getValue((Property)FACING) && ClosetBlock.getConnectedDirection(otherState) == direction.getOpposite()) {
                return (BlockState)state.setValue((Property)TYPE, (Comparable)chesttype.getOpposite());
            }
        } else if (ClosetBlock.getConnectedDirection(state) == direction) {
            return (BlockState)state.setValue((Property)TYPE, (Comparable)ChestType.SINGLE);
        }
        return state;
    }

    public static boolean isChestBlockedAt(LevelAccessor level, BlockPos pos) {
        Direction facing = (Direction)level.getBlockState(pos).getValue((Property)FACING);
        BlockPos offsetPos = pos.relative(facing);
        return level.getBlockState(offsetPos).isRedstoneConductor((BlockGetter)level, offsetPos);
    }

    public static Direction getConnectedDirection(BlockState state) {
        return state.getValue((Property)TYPE) == ChestType.LEFT ? Direction.DOWN : Direction.UP;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        DoorHingeSide hinge2;
        Direction direction2;
        ChestType chestType = ChestType.SINGLE;
        Direction facingDirection = context.getHorizontalDirection().getOpposite();
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        boolean isSneaking = context.isSecondaryUseActive();
        Direction direction1 = context.getClickedFace();
        DoorHingeSide hinge = this.getHinge(context);
        if (direction1.getAxis().isVertical() && isSneaking && (direction2 = this.candidatePartnerFacing(context, direction1.getOpposite())) != null && direction2 == facingDirection && direction2.getAxis() != direction1.getAxis()) {
            chestType = direction1 == Direction.DOWN ? ChestType.RIGHT : ChestType.LEFT;
            DoorHingeSide hinge22 = this.candidatePartnerHinge(context, direction1.getOpposite());
            if (hinge22 != null) {
                hinge = hinge22;
            }
        }
        if (direction1.getAxis().isHorizontal() && isSneaking && (hinge2 = this.candidatePartnerHinge(context, direction1.getOpposite())) != null) {
            DoorHingeSide doorHingeSide = hinge = hinge2 == DoorHingeSide.LEFT ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
        }
        if (chestType == ChestType.SINGLE && !isSneaking) {
            if (facingDirection == this.candidatePartnerFacing(context, Direction.DOWN)) {
                chestType = ChestType.LEFT;
                hinge2 = this.candidatePartnerHinge(context, Direction.DOWN);
                if (hinge2 != null) {
                    hinge = hinge2;
                }
            } else if (facingDirection == this.candidatePartnerFacing(context, Direction.UP)) {
                chestType = ChestType.RIGHT;
                hinge2 = this.candidatePartnerHinge(context, Direction.UP);
                if (hinge2 != null) {
                    hinge = hinge2;
                }
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facingDirection)).setValue(HINGE, (Comparable)hinge)).setValue((Property)TYPE, (Comparable)chestType)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockPos abovePos = pos.above();
        Direction dir = context.getHorizontalDirection();
        Direction dirCCW = dir.getCounterClockWise();
        BlockPos posCCW = pos.relative(dirCCW);
        BlockState stateCCW = level.getBlockState(posCCW);
        BlockPos abovePosCCW = abovePos.relative(dirCCW);
        BlockState aboveStateCCW = level.getBlockState(abovePosCCW);
        Direction dirCW = dir.getClockWise();
        BlockPos posCW = pos.relative(dirCW);
        BlockState stateCW = level.getBlockState(posCW);
        BlockPos abovePosCW = abovePos.relative(dirCW);
        BlockState aboveStateCW = level.getBlockState(abovePosCW);
        int i = (stateCCW.isCollisionShapeFullBlock((BlockGetter)level, posCCW) ? -1 : 0) + (aboveStateCCW.isCollisionShapeFullBlock((BlockGetter)level, abovePosCCW) ? -1 : 0) + (stateCW.isCollisionShapeFullBlock((BlockGetter)level, posCW) ? 1 : 0) + (aboveStateCW.isCollisionShapeFullBlock((BlockGetter)level, abovePosCW) ? 1 : 0);
        boolean flag = stateCCW.is((Block)this);
        boolean flag1 = stateCW.is((Block)this);
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = dir.getStepX();
                int k = dir.getStepZ();
                Vec3 vec3 = context.getClickLocation();
                double d0 = vec3.x - (double)pos.getX();
                double d1 = vec3.z - (double)pos.getZ();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    @Nullable
    private Direction candidatePartnerFacing(BlockPlaceContext context, Direction direction) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos().relative(direction));
        return state.is((Block)this) && state.getValue((Property)TYPE) == ChestType.SINGLE ? (Direction)state.getValue((Property)FACING) : null;
    }

    @Nullable
    private DoorHingeSide candidatePartnerHinge(BlockPlaceContext context, Direction direction) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos().relative(direction));
        return state.is((Block)this) && state.getValue((Property)TYPE) == ChestType.SINGLE ? (DoorHingeSide)state.getValue(HINGE) : null;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)super.mirror(state, mirror).cycle(HINGE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HINGE});
    }
}

