/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.common.block;

import com.teamabnormals.woodworks.common.inventory.SawmillMenu;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SawmillBlock
extends Block {
    public static final Component CONTAINER_TITLE = Component.translatable((String)"container.woodworks.sawmill");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final VoxelShape[] SHAPES = new VoxelShape[]{Shapes.or((VoxelShape)SawmillBlock.box((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)SawmillBlock.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)2.0, (double)9.0)), Shapes.or((VoxelShape)SawmillBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)7.0), (VoxelShape)SawmillBlock.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)16.0)), Shapes.or((VoxelShape)SawmillBlock.box((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)SawmillBlock.box((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)2.0, (double)9.0)), Shapes.or((VoxelShape)SawmillBlock.box((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape)SawmillBlock.box((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)2.0, (double)9.0))};

    public SawmillBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        player.openMenu(state.getMenuProvider(level, pos));
        player.awardStat(Stats.INTERACT_WITH_STONECUTTER);
        return InteractionResult.CONSUME;
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new SawmillMenu(id, inventory, ContainerLevelAccess.create((Level)level, (BlockPos)pos)), CONTAINER_TITLE);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue((Property)FACING)).get3DDataValue() - 2];
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

