/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.common.block;

import com.teamabnormals.blueprint.core.api.IChestBlock;
import com.teamabnormals.woodworks.common.block.ClosetBlock;
import com.teamabnormals.woodworks.common.block.entity.TrappedClosetBlockEntity;
import com.teamabnormals.woodworks.core.registry.WoodworksBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class TrappedClosetBlock
extends ClosetBlock
implements IChestBlock {
    public TrappedClosetBlock(String type, BlockBehaviour.Properties props) {
        super(type, props, () -> WoodworksBlockEntityTypes.TRAPPED_CLOSET.get());
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrappedClosetBlockEntity(pos, state);
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.CUSTOM.get((Object)Stats.TRIGGER_TRAPPED_CHEST);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return Mth.clamp((int)ChestBlockEntity.getOpenCount((BlockGetter)getter, (BlockPos)pos), (int)0, (int)15);
    }

    public int getDirectSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return face == Direction.UP ? state.getSignal(getter, pos, face) : 0;
    }
}

