/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.common.block.entity;

import com.teamabnormals.woodworks.common.block.ClosetBlock;
import com.teamabnormals.woodworks.core.registry.WoodworksBlockEntityTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public class ClosetBlockEntity
extends ChestBlockEntity {
    public static final String CONTAINER_CLOSET = "container.woodworks.closet";
    public static final String CONTAINER_CLOSET_DOUBLE = "container.woodworks.closetDouble";
    private final ContainerOpenersCounter newOpenersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            ClosetBlockEntity.playSound(level, pos, state, (SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CLOSET_OPEN.get());
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            ClosetBlockEntity.playSound(level, pos, state, (SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CLOSET_CLOSE.get());
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int num1, int num2) {
            ClosetBlockEntity.this.signalOpenCount(level, pos, state, num1, num2);
        }

        protected boolean isOwnContainer(Player player) {
            CompoundContainer compoundContainer;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (!(abstractContainerMenu instanceof ChestMenu)) {
                return false;
            }
            ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
            Container container = chestMenu.getContainer();
            return container == ClosetBlockEntity.this || container instanceof CompoundContainer && (compoundContainer = (CompoundContainer)container).contains((Container)ClosetBlockEntity.this);
        }
    };

    public static void playSound(Level level, BlockPos pos, BlockState state, SoundEvent event) {
        ChestType chesttype = (ChestType)state.getValue((Property)ChestBlock.TYPE);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = (double)pos.getY() + 0.5;
            double d2 = (double)pos.getZ() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ClosetBlock.getConnectedDirection(state);
                d1 += (double)direction.getStepY() * 0.5;
            }
            level.playSound(null, d0, d1, d2, event, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
        }
    }

    protected ClosetBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public ClosetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)WoodworksBlockEntityTypes.CLOSET.get(), pos, state);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)CONTAINER_CLOSET);
    }

    public boolean canOpen(Player player) {
        return ClosetBlockEntity.canUnlock(player, this.lockKey, this.getDisplayName());
    }

    public static boolean canUnlock(Player player, LockCode code, Component component) {
        if (!player.isSpectator() && !code.unlocksWith(player.getMainHandItem())) {
            player.displayClientMessage((Component)Component.translatable((String)"container.isLocked", (Object[])new Object[]{component}), true);
            player.playNotifySound((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CLOSET_LOCKED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }
}

