/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core;

import com.teamabnormals.blueprint.client.screen.splash.SplashSerializers;
import com.teamabnormals.blueprint.core.util.registry.ISubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.woodworks.client.splashes.ClayworksSplash;
import com.teamabnormals.woodworks.core.WoodworksConfig;
import com.teamabnormals.woodworks.core.data.client.WoodworksBlockStateProvider;
import com.teamabnormals.woodworks.core.data.client.WoodworksLanguageProvider;
import com.teamabnormals.woodworks.core.data.client.WoodworksSoundDefinitionsProvider;
import com.teamabnormals.woodworks.core.data.client.WoodworksSplashProvider;
import com.teamabnormals.woodworks.core.data.server.WoodworksAdvancementProvider;
import com.teamabnormals.woodworks.core.data.server.WoodworksDatapackProvider;
import com.teamabnormals.woodworks.core.data.server.WoodworksLootTableProvider;
import com.teamabnormals.woodworks.core.data.server.WoodworksRecipeProvider;
import com.teamabnormals.woodworks.core.data.server.tags.WoodworksBlockTagsProvider;
import com.teamabnormals.woodworks.core.data.server.tags.WoodworksItemTagsProvider;
import com.teamabnormals.woodworks.core.other.WoodworksClientCompat;
import com.teamabnormals.woodworks.core.other.WoodworksCompat;
import com.teamabnormals.woodworks.core.other.WoodworksDataProcessors;
import com.teamabnormals.woodworks.core.registry.WoodworksBlockEntityTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import com.teamabnormals.woodworks.core.registry.WoodworksConditionSerializers;
import com.teamabnormals.woodworks.core.registry.WoodworksMenuTypes;
import com.teamabnormals.woodworks.core.registry.WoodworksRecipes;
import com.teamabnormals.woodworks.core.registry.WoodworksSoundEvents;
import com.teamabnormals.woodworks.core.registry.helper.WoodworksBlockSubRegistryHelper;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod(value="woodworks")
public class Woodworks {
    public static final String MOD_ID = "woodworks";
    public static final RegistryHelper REGISTRY_HELPER = RegistryHelper.create((String)"woodworks", helper -> helper.putSubHelper(Registries.BLOCK, (ISubRegistryHelper)new WoodworksBlockSubRegistryHelper((RegistryHelper)helper)));

    public Woodworks(IEventBus bus, ModContainer container) {
        WoodworksDataProcessors.registerTrackedData();
        WoodworksBlocks.BLOCKS.register(bus);
        WoodworksBlocks.ITEMS.register(bus);
        WoodworksBlockEntityTypes.BLOCK_ENTITY_TYPES.register(bus);
        WoodworksSoundEvents.SOUND_EVENTS.register(bus);
        WoodworksConditionSerializers.CONDITION_SERIALIZERS.register(bus);
        WoodworksMenuTypes.MENU_TYPES.register(bus);
        WoodworksRecipes.WoodworksRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        WoodworksRecipes.WoodworksRecipeTypes.RECIPE_TYPES.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            SplashSerializers.register((ResourceLocation)Woodworks.location("clayworks"), ClayworksSplash.CODEC);
        }
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WoodworksConfig.COMMON_SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(WoodworksCompat::register);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(WoodworksClientCompat::register);
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        WoodworksBlockTagsProvider blockTags = new WoodworksBlockTagsProvider(output, provider, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new WoodworksItemTagsProvider(output, provider, blockTags.contentsGetter(), helper));
        generator.addProvider(server, (DataProvider)new WoodworksLootTableProvider(output, provider));
        generator.addProvider(server, (DataProvider)new WoodworksRecipeProvider(output, provider));
        generator.addProvider(server, (DataProvider)new WoodworksDatapackProvider(output, provider));
        generator.addProvider(server, (DataProvider)WoodworksAdvancementProvider.create(output, provider, helper));
        boolean client = event.includeClient();
        generator.addProvider(client, (DataProvider)new WoodworksSplashProvider(output));
        generator.addProvider(client, (DataProvider)new WoodworksBlockStateProvider(output, helper));
        generator.addProvider(client, (DataProvider)new WoodworksLanguageProvider(output));
        generator.addProvider(client, (DataProvider)new WoodworksSoundDefinitionsProvider(output, helper));
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

