/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core;

import com.teamabnormals.blueprint.core.annotations.ConfigKey;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class WoodworksConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        @ConfigKey(value="sawmill")
        public final ModConfigSpec.BooleanValue sawmill;
        @ConfigKey(value="wooden_boards")
        public final ModConfigSpec.BooleanValue woodenBoards;
        @ConfigKey(value="wooden_bookshelves")
        public final ModConfigSpec.BooleanValue woodenBookshelves;
        @ConfigKey(value="wooden_ladders")
        public final ModConfigSpec.BooleanValue woodenLadders;
        @ConfigKey(value="wooden_beehives")
        public final ModConfigSpec.BooleanValue woodenBeehives;
        @ConfigKey(value="wooden_chests")
        public final ModConfigSpec.BooleanValue woodenChests;
        @ConfigKey(value="mixed_chest_crafting")
        public final ModConfigSpec.BooleanValue mixedChestCrafting;
        @ConfigKey(value="leaf_piles")
        public final ModConfigSpec.BooleanValue leafPiles;
        @ConfigKey(value="wooden_bookshelves_in_villages")
        public final ModConfigSpec.BooleanValue woodenBookshelvesInVillages;
        @ConfigKey(value="wooden_ladders_in_villages")
        public final ModConfigSpec.BooleanValue woodenLaddersInVillages;
        @ConfigKey(value="wooden_chests_in_villages")
        public final ModConfigSpec.BooleanValue woodenChestsInVillages;

        public Common(ModConfigSpec.Builder builder) {
            builder.push("blocks");
            this.sawmill = builder.define("Sawmill", true);
            this.woodenBoards = builder.define("Wooden boards", true);
            this.woodenBookshelves = builder.define("Wooden bookshelves", true);
            this.woodenLadders = builder.define("Wooden ladders", true);
            this.woodenBeehives = builder.define("Wooden beehives", true);
            this.woodenChests = builder.define("Wooden chests", true);
            this.mixedChestCrafting = builder.comment("If the vanilla Chest can be crafted from mixing woods or woods without a chest variant").define("Mixed chest crafting", true);
            this.leafPiles = builder.define("Leaf piles", true);
            builder.pop();
            builder.push("generation");
            this.woodenBookshelvesInVillages = builder.comment("If variant bookshelves replace bookshelves in Villages").define("Wooden bookshelves in Villages", true);
            this.woodenLaddersInVillages = builder.comment("If variant ladders replace ladders in Villages").define("Wooden ladders in Villages", true);
            this.woodenChestsInVillages = builder.comment("If variant chests replace chests in Villages").define("Wooden chests in Villages", true);
            builder.pop();
        }
    }
}

