/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.data.client;

import com.teamabnormals.blueprint.common.block.LeafPileBlock;
import com.teamabnormals.blueprint.core.data.client.BlueprintLanguageProvider;
import com.teamabnormals.woodworks.common.block.SawmillBlock;
import com.teamabnormals.woodworks.core.Woodworks;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import net.minecraft.Util;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredRegister;

public class WoodworksLanguageProvider
extends BlueprintLanguageProvider {
    public WoodworksLanguageProvider(PackOutput output) {
        super(output, "woodworks");
    }

    protected void addTranslations() {
        this.add("oak_bookshelf");
        this.add("chiseled_oak_bookshelf");
        this.add("oak_ladder");
        this.add("oak_beehive");
        ((DeferredRegister.Blocks)WoodworksBlocks.BLOCKS.getDeferredRegister()).getEntries().forEach(block -> this.add((Block)block.get(), (String)(block.get() instanceof LeafPileBlock ? "Pile of " + this.format(block.getId()).replace("Leaf Pile", "Leaves") : this.format(block.getId()))));
        this.add(SawmillBlock.CONTAINER_TITLE.getString(), "Sawmill");
        this.add("gui.woodworks.category.sawmill", "Sawing");
        this.add("container.woodworks.closet", "Closet");
        this.add("container.woodworks.closetDouble", "Large Closet");
        this.subtitle("block.closet.open", "Closet opens");
        this.subtitle("block.closet.close", "Closet closes");
        this.subtitle("block.closet.locked", "Closet locked");
    }

    private void add(String block) {
        this.add(Util.makeDescriptionId((String)"block", (ResourceLocation)Woodworks.location(block)), this.format(block));
    }

    private void subtitle(String key, String subtitle) {
        this.add(Util.makeDescriptionId((String)"subtitles", (ResourceLocation)Woodworks.location(key)), subtitle);
    }
}

