/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.data.client;

import com.teamabnormals.woodworks.core.registry.WoodworksSoundEvents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.SoundDefinition;
import net.neoforged.neoforge.common.data.SoundDefinitionsProvider;

public class WoodworksSoundDefinitionsProvider
extends SoundDefinitionsProvider {
    public WoodworksSoundDefinitionsProvider(PackOutput output, ExistingFileHelper helper) {
        super(output, "woodworks", helper);
    }

    public void registerSounds() {
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_LADDER_BREAK.get(), WoodworksSoundDefinitionsProvider.vanilla("block/cherry_wood/break", 5, "subtitles.block.generic.break"));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_LADDER_STEP.get(), WoodworksSoundDefinitionsProvider.define("block/cherry_wood_ladder/step", 5, "subtitles.block.generic.footsteps"));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_LADDER_PLACE.get(), WoodworksSoundDefinitionsProvider.vanilla("block/cherry_wood/break", 5, "subtitles.block.generic.place"));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_LADDER_HIT.get(), WoodworksSoundDefinitionsProvider.define("block/cherry_wood_ladder/step", 5, "subtitles.block.generic.hit"));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_LADDER_FALL.get(), WoodworksSoundDefinitionsProvider.define("block/cherry_wood_ladder/step", 5));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_CHISELED_BOOKSHELF_BREAK.get(), WoodworksSoundDefinitionsProvider.define("block/cherry_wood_chiseled_bookshelf/break", 6, "subtitles.block.generic.break"));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_CHISELED_BOOKSHELF_STEP.get(), WoodworksSoundDefinitionsProvider.define("block/cherry_wood_chiseled_bookshelf/step", 5, "subtitles.block.generic.footsteps"));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_CHISELED_BOOKSHELF_PLACE.get(), WoodworksSoundDefinitionsProvider.define("block/cherry_wood_chiseled_bookshelf/break", 6, "subtitles.block.generic.place"));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_CHISELED_BOOKSHELF_HIT.get(), WoodworksSoundDefinitionsProvider.define("block/cherry_wood_chiseled_bookshelf/step", 5, "subtitles.block.generic.hit"));
        this.add((SoundEvent)WoodworksSoundEvents.CHERRY_WOOD_CHISELED_BOOKSHELF_FALL.get(), WoodworksSoundDefinitionsProvider.define("block/cherry_wood_chiseled_bookshelf/step", 5));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_LADDER_BREAK.get(), WoodworksSoundDefinitionsProvider.vanilla("block/bamboo_wood/break", 5, "subtitles.block.generic.break", 0.9f));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_LADDER_STEP.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_ladder/step", 5, "subtitles.block.generic.footsteps"));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_LADDER_PLACE.get(), WoodworksSoundDefinitionsProvider.vanilla("block/bamboo_wood/break", 5, "subtitles.block.generic.place", 0.9f));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_LADDER_HIT.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_ladder/step", 5, "subtitles.block.generic.hit"));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_LADDER_FALL.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_ladder/step", 5));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CHISELED_BOOKSHELF_BREAK.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_chiseled_bookshelf/break", 6, "subtitles.block.generic.break"));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CHISELED_BOOKSHELF_STEP.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_chiseled_bookshelf/step", 5, "subtitles.block.generic.footsteps"));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CHISELED_BOOKSHELF_PLACE.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_chiseled_bookshelf/break", 6, "subtitles.block.generic.place"));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CHISELED_BOOKSHELF_HIT.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_chiseled_bookshelf/step", 5, "subtitles.block.generic.hit"));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CHISELED_BOOKSHELF_FALL.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_chiseled_bookshelf/step", 5));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CLOSET_OPEN.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_closet/open", 1, "subtitles.woodworks.block.closet.open"));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CLOSET_CLOSE.get(), WoodworksSoundDefinitionsProvider.define("block/bamboo_wood_closet/close", 1, "subtitles.woodworks.block.closet.close"));
        this.add((SoundEvent)WoodworksSoundEvents.BAMBOO_WOOD_CLOSET_LOCKED.get(), WoodworksSoundDefinitionsProvider.vanilla(List.of("block/chest/close_locked", "block/chest/open_locked"), "subtitles.woodworks.block.closet.locked"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_LADDER_BREAK.get(), WoodworksSoundDefinitionsProvider.vanilla("block/nether_wood/break", 4, "subtitles.block.generic.break"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_LADDER_STEP.get(), WoodworksSoundDefinitionsProvider.define("block/nether_wood_ladder/step", 5, "subtitles.block.generic.footsteps"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_LADDER_PLACE.get(), WoodworksSoundDefinitionsProvider.vanilla("block/nether_wood/break", 4, "subtitles.block.generic.place"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_LADDER_HIT.get(), WoodworksSoundDefinitionsProvider.define("block/nether_wood_ladder/step", 5, "subtitles.block.generic.hit"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_LADDER_FALL.get(), WoodworksSoundDefinitionsProvider.define("block/nether_wood_ladder/step", 5));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_CHISELED_BOOKSHELF_BREAK.get(), WoodworksSoundDefinitionsProvider.define("block/nether_wood_chiseled_bookshelf/break", 6, "subtitles.block.generic.break"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_CHISELED_BOOKSHELF_PLACE.get(), WoodworksSoundDefinitionsProvider.define("block/nether_wood_chiseled_bookshelf/break", 6, "subtitles.block.generic.place"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_CHISELED_BOOKSHELF_STEP.get(), WoodworksSoundDefinitionsProvider.define("block/nether_wood_chiseled_bookshelf/step", 5, "subtitles.block.generic.footsteps"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_CHISELED_BOOKSHELF_HIT.get(), WoodworksSoundDefinitionsProvider.define("block/nether_wood_chiseled_bookshelf/step", 5, "subtitles.block.generic.hit"));
        this.add((SoundEvent)WoodworksSoundEvents.NETHER_WOOD_CHISELED_BOOKSHELF_FALL.get(), WoodworksSoundDefinitionsProvider.define("block/nether_wood_chiseled_bookshelf/step", 5));
    }

    public static SoundDefinition vanilla(String path, int count, String subtitle) {
        return WoodworksSoundDefinitionsProvider.define("minecraft", path, count, subtitle, 1.0f);
    }

    public static SoundDefinition vanilla(String path, int count, String subtitle, float volume) {
        return WoodworksSoundDefinitionsProvider.define("minecraft", path, count, subtitle, volume);
    }

    public static SoundDefinition define(String path, int count) {
        return WoodworksSoundDefinitionsProvider.define(path, count, null);
    }

    public static SoundDefinition define(String path, int count, String subtitle) {
        return WoodworksSoundDefinitionsProvider.define("woodworks", path, count, subtitle, 1.0f);
    }

    public static SoundDefinition define(String modid, String path, int count, @Nullable String subtitle, float volume) {
        SoundDefinition definition = WoodworksSoundDefinitionsProvider.definition();
        if (subtitle != null) {
            definition.subtitle(subtitle);
        }
        for (int i = 1; i <= count; ++i) {
            definition.with(WoodworksSoundDefinitionsProvider.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)(path + i))).volume(volume));
        }
        return definition;
    }

    public static SoundDefinition vanilla(List<String> paths, String subtitle) {
        return WoodworksSoundDefinitionsProvider.define("minecraft", paths, subtitle, 1.0f);
    }

    public static SoundDefinition define(String modid, List<String> strings, @Nullable String subtitle, float volume) {
        SoundDefinition definition = WoodworksSoundDefinitionsProvider.definition();
        if (subtitle != null) {
            definition.subtitle(subtitle);
        }
        for (String path : strings) {
            definition.with(WoodworksSoundDefinitionsProvider.sound((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)path)).volume(volume));
        }
        return definition;
    }
}

