/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.data.server;

import com.teamabnormals.blueprint.core.other.tags.BlueprintBlockTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class WoodworksAdvancementProvider
implements AdvancementProvider.AdvancementGenerator {
    public static AdvancementProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, ExistingFileHelper helper) {
        return new AdvancementProvider(output, provider, helper, List.of(new WoodworksAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper helper) {
        Advancement.Builder.advancement().parent(ResourceLocation.withDefaultNamespace((String)"adventure/root")).display((ItemLike)Items.CHISELED_BOOKSHELF, (Component)Component.translatable((String)"advancements.adventure.read_power_from_chiseled_bookshelf.title"), (Component)Component.translatable((String)"advancements.adventure.read_power_from_chiseled_bookshelf.description"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR).addCriterion("chiseled_bookshelf", WoodworksAdvancementProvider.placedBlockReadByComparator((TagKey<Block>)BlueprintBlockTags.WOODEN_CHISELED_BOOKSHELVES)).addCriterion("comparator", WoodworksAdvancementProvider.placedComparatorReadingBlock((TagKey<Block>)BlueprintBlockTags.WOODEN_CHISELED_BOOKSHELVES)).save(consumer, "adventure/read_power_of_chiseled_bookshelf");
    }

    private static Criterion<ItemUsedOnLocationTrigger.TriggerInstance> placedBlockReadByComparator(TagKey<Block> block) {
        LootItemCondition.Builder[] condition = (LootItemCondition.Builder[])ComparatorBlock.FACING.getPossibleValues().stream().map(direction -> {
            StatePropertiesPredicate.Builder statePredicate = StatePropertiesPredicate.Builder.properties().hasProperty((Property)ComparatorBlock.FACING, (Comparable)direction);
            BlockPredicate.Builder comparatorPredicate = BlockPredicate.Builder.block().of(new Block[]{Blocks.COMPARATOR}).setProperties(statePredicate);
            return LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(comparatorPredicate), (BlockPos)new BlockPos(direction.getOpposite().getNormal()));
        }).toArray(LootItemCondition.Builder[]::new);
        return ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(block))), AnyOfCondition.anyOf((LootItemCondition.Builder[])condition)});
    }

    private static Criterion<ItemUsedOnLocationTrigger.TriggerInstance> placedComparatorReadingBlock(TagKey<Block> block) {
        LootItemCondition.Builder[] condition = (LootItemCondition.Builder[])ComparatorBlock.FACING.getPossibleValues().stream().map(direction -> {
            StatePropertiesPredicate.Builder statePredicate = StatePropertiesPredicate.Builder.properties().hasProperty((Property)ComparatorBlock.FACING, (Comparable)direction);
            LootItemBlockStatePropertyCondition.Builder comparatorPredicate = new LootItemBlockStatePropertyCondition.Builder(Blocks.COMPARATOR).setProperties(statePredicate);
            LootItemCondition.Builder locationPredicate = LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(block)), (BlockPos)new BlockPos(direction.getNormal()));
            return AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{comparatorPredicate, locationPredicate});
        }).toArray(LootItemCondition.Builder[]::new);
        return ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((LootItemCondition.Builder[])new LootItemCondition.Builder[]{AnyOfCondition.anyOf((LootItemCondition.Builder[])condition)});
    }
}

