/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.data.server;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.common.Tags;

public class WoodworksLootTableProvider
extends LootTableProvider {
    public WoodworksLootTableProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super(output, BuiltInLootTables.all(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(WoodworksBlockLoot::new, LootContextParamSets.BLOCK)), provider);
    }

    protected void validate(WritableRegistry<LootTable> registry, ValidationContext context, ProblemReporter.Collector collector) {
    }

    private static class WoodworksBlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.DRAGON_EGG, Blocks.BEACON, Blocks.CONDUIT, Blocks.SKELETON_SKULL, Blocks.WITHER_SKELETON_SKULL, Blocks.PLAYER_HEAD, Blocks.ZOMBIE_HEAD, Blocks.CREEPER_HEAD, Blocks.DRAGON_HEAD, Blocks.PIGLIN_HEAD, Blocks.SHULKER_BOX, Blocks.BLACK_SHULKER_BOX, Blocks.BLUE_SHULKER_BOX, Blocks.BROWN_SHULKER_BOX, Blocks.CYAN_SHULKER_BOX, Blocks.GRAY_SHULKER_BOX, Blocks.GREEN_SHULKER_BOX, Blocks.LIGHT_BLUE_SHULKER_BOX, Blocks.LIGHT_GRAY_SHULKER_BOX, Blocks.LIME_SHULKER_BOX, Blocks.MAGENTA_SHULKER_BOX, Blocks.ORANGE_SHULKER_BOX, Blocks.PINK_SHULKER_BOX, Blocks.PURPLE_SHULKER_BOX, Blocks.RED_SHULKER_BOX, Blocks.WHITE_SHULKER_BOX, Blocks.YELLOW_SHULKER_BOX).map(ItemLike::asItem).collect(Collectors.toSet());

        protected WoodworksBlockLoot(HolderLookup.Provider provider) {
            super(EXPLOSION_RESISTANT, FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
            this.dropSelf((Block)WoodworksBlocks.SAWMILL.get());
            this.dropSelf((Block)WoodworksBlocks.OAK_BOARDS.get());
            this.add((Block)WoodworksBlocks.OAK_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.OAK_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_OAK_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.SPRUCE_BOARDS.get());
            this.add((Block)WoodworksBlocks.SPRUCE_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.SPRUCE_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_SPRUCE_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.SPRUCE_LADDER.get());
            this.add((Block)WoodworksBlocks.SPRUCE_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.SPRUCE_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_SPRUCE_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.BIRCH_BOARDS.get());
            this.add((Block)WoodworksBlocks.BIRCH_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.BIRCH_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_BIRCH_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.BIRCH_LADDER.get());
            this.add((Block)WoodworksBlocks.BIRCH_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.BIRCH_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_BIRCH_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.JUNGLE_BOARDS.get());
            this.add((Block)WoodworksBlocks.JUNGLE_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.JUNGLE_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_JUNGLE_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.JUNGLE_LADDER.get());
            this.add((Block)WoodworksBlocks.JUNGLE_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.JUNGLE_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_JUNGLE_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.ACACIA_BOARDS.get());
            this.add((Block)WoodworksBlocks.ACACIA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.ACACIA_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_ACACIA_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.ACACIA_LADDER.get());
            this.add((Block)WoodworksBlocks.ACACIA_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.ACACIA_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_ACACIA_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.DARK_OAK_BOARDS.get());
            this.add((Block)WoodworksBlocks.DARK_OAK_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.DARK_OAK_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_DARK_OAK_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.DARK_OAK_LADDER.get());
            this.add((Block)WoodworksBlocks.DARK_OAK_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.DARK_OAK_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_DARK_OAK_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.MANGROVE_BOARDS.get());
            this.add((Block)WoodworksBlocks.MANGROVE_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.MANGROVE_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_MANGROVE_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.MANGROVE_LADDER.get());
            this.add((Block)WoodworksBlocks.MANGROVE_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.MANGROVE_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_MANGROVE_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.CHERRY_BOARDS.get());
            this.add((Block)WoodworksBlocks.CHERRY_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.CHERRY_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_CHERRY_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.CHERRY_LADDER.get());
            this.add((Block)WoodworksBlocks.CHERRY_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.CHERRY_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_CHERRY_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.BAMBOO_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_BAMBOO_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.BAMBOO_LADDER.get());
            this.add((Block)WoodworksBlocks.BAMBOO_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.BAMBOO_CLOSET.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_BAMBOO_CLOSET.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.CRIMSON_BOARDS.get());
            this.add((Block)WoodworksBlocks.CRIMSON_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_CRIMSON_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.CRIMSON_LADDER.get());
            this.add((Block)WoodworksBlocks.CRIMSON_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.CRIMSON_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_CRIMSON_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.dropSelf((Block)WoodworksBlocks.WARPED_BOARDS.get());
            this.add((Block)WoodworksBlocks.WARPED_BOOKSHELF.get(), this::createBookshelfDrops);
            this.dropWhenSilkTouch((Block)WoodworksBlocks.CHISELED_WARPED_BOOKSHELF.get());
            this.dropSelf((Block)WoodworksBlocks.WARPED_LADDER.get());
            this.add((Block)WoodworksBlocks.WARPED_BEEHIVE.get(), x$0 -> this.createBeeHiveDrop((Block)x$0));
            this.add((Block)WoodworksBlocks.WARPED_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.TRAPPED_WARPED_CHEST.get(), x$0 -> this.createNameableBlockEntityTable((Block)x$0));
            this.add((Block)WoodworksBlocks.AZALEA_LEAF_PILE.get(), this::createLeafPileDrops);
            this.add((Block)WoodworksBlocks.FLOWERING_AZALEA_LEAF_PILE.get(), this::createLeafPileDrops);
        }

        protected LootTable.Builder createLeafPileDrops(Block block) {
            return this.createMultifaceBlockDrops(block, MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(Tags.Items.TOOLS_SHEAR)));
        }

        protected LootTable.Builder createBookshelfDrops(Block block) {
            return this.createSingleItemTableWithSilkTouch(block, (ItemLike)Items.BOOK, (NumberProvider)ConstantValue.exactly((float)3.0f));
        }

        public Iterable<Block> getKnownBlocks() {
            return BuiltInRegistries.BLOCK.stream().filter(block -> "woodworks".equals(BuiltInRegistries.BLOCK.getKey(block).getNamespace())).collect(Collectors.toSet());
        }
    }
}

