/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.data.server;

import com.teamabnormals.blueprint.core.api.conditions.BlueprintAndCondition;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.data.server.BlueprintRecipeProvider;
import com.teamabnormals.woodworks.common.WoodenChestRecipe;
import com.teamabnormals.woodworks.common.item.crafting.SawmillRecipe;
import com.teamabnormals.woodworks.core.Woodworks;
import com.teamabnormals.woodworks.core.WoodworksConfig;
import com.teamabnormals.woodworks.core.other.WoodworksConditions;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class WoodworksRecipeProvider
extends BlueprintRecipeProvider
implements IConditionBuilder {
    public WoodworksRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
        super("woodworks", output, provider);
    }

    public void buildRecipes(RecipeOutput output) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)WoodworksBlocks.SAWMILL.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).pattern("#I").pattern("# ").pattern("#S").unlockedBy("has_planks", WoodworksRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(output.withConditions(new ICondition[]{WoodworksConditions.SAWMILL_ENABLED}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.BOOKSHELF).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), (ItemLike)Items.BOOK).pattern("###").pattern("XXX").pattern("###").unlockedBy("has_book", WoodworksRecipeProvider.has((ItemLike)Items.BOOK)).save(output.withConditions(new ICondition[]{WoodworksConditions.config(WoodworksConfig.COMMON.woodenBookshelves, "wooden_bookshelves", true)}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)Blocks.CHISELED_BOOKSHELF).define(Character.valueOf('#'), ItemTags.PLANKS).define(Character.valueOf('X'), ItemTags.WOODEN_SLABS).pattern("###").pattern("XXX").pattern("###").unlockedBy("has_book", WoodworksRecipeProvider.has((ItemLike)Items.BOOK)).save(output.withConditions(new ICondition[]{WoodworksConditions.config(WoodworksConfig.COMMON.woodenBookshelves, "wooden_bookshelves", true)}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.LADDER, (int)3).define(Character.valueOf('#'), (ItemLike)Items.STICK).pattern("# #").pattern("###").pattern("# #").unlockedBy("has_stick", WoodworksRecipeProvider.has((ItemLike)Items.STICK)).save(output.withConditions(new ICondition[]{WoodworksConditions.config(WoodworksConfig.COMMON.woodenLadders, "wooden_ladders", true)}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.BEEHIVE).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('H'), (ItemLike)Items.HONEYCOMB).pattern("PPP").pattern("HHH").pattern("PPP").unlockedBy("has_honeycomb", WoodworksRecipeProvider.has((ItemLike)Items.HONEYCOMB)).save(output.withConditions(new ICondition[]{WoodworksConditions.config(WoodworksConfig.COMMON.woodenBeehives, "wooden_beehives", true)}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.CHEST).define(Character.valueOf('#'), ItemTags.PLANKS).pattern("###").pattern("# #").pattern("###").unlockedBy("has_lots_of_items", CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), new InventoryChangeTrigger.TriggerInstance.Slots(MinMaxBounds.Ints.atLeast((int)10), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY), List.of()))).save(output.withConditions(new ICondition[]{WoodworksConditions.config(WoodworksConfig.COMMON.woodenChests, "wooden_chests", true)}));
        SpecialRecipeBuilder.special(WoodenChestRecipe::new).save(output.withConditions(new ICondition[]{WoodworksConditions.MIXED_CHEST_CRAFTING}), "woodworks:wooden_chest");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.TRAPPED_CHEST).requires(Tags.Items.CHESTS_WOODEN).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", WoodworksRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(output.withConditions(new ICondition[]{WoodworksConditions.config(WoodworksConfig.COMMON.woodenChests, "wooden_chests", true)}));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.TRAPPED_CHEST).requires((ItemLike)Blocks.CHEST).requires((ItemLike)Blocks.TRIPWIRE_HOOK).unlockedBy("has_tripwire_hook", WoodworksRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(output.withConditions(new ICondition[]{WoodworksConditions.WOODEN_CHESTS}), Woodworks.location("trapped_chest"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)Blocks.LECTERN).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('B'), Tags.Items.BOOKSHELVES).pattern("SSS").pattern(" B ").pattern(" S ").unlockedBy("has_book", WoodworksRecipeProvider.has((ItemLike)Items.BOOK)).save(output);
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.OAK_PLANKS, (ItemLike)Blocks.OAK_SLAB, (ItemLike)WoodworksBlocks.OAK_BOARDS.get(), (ItemLike)Blocks.BOOKSHELF, (ItemLike)Blocks.CHISELED_BOOKSHELF, (ItemLike)Blocks.LADDER, (ItemLike)Blocks.BEEHIVE, (ItemLike)WoodworksBlocks.OAK_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_OAK_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.SPRUCE_PLANKS, (ItemLike)Blocks.SPRUCE_SLAB, (ItemLike)WoodworksBlocks.SPRUCE_BOARDS.get(), (ItemLike)WoodworksBlocks.SPRUCE_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_SPRUCE_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.SPRUCE_LADDER.get(), (ItemLike)WoodworksBlocks.SPRUCE_BEEHIVE.get(), (ItemLike)WoodworksBlocks.SPRUCE_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_SPRUCE_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.BIRCH_PLANKS, (ItemLike)Blocks.BIRCH_SLAB, (ItemLike)WoodworksBlocks.BIRCH_BOARDS.get(), (ItemLike)WoodworksBlocks.BIRCH_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_BIRCH_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.BIRCH_LADDER.get(), (ItemLike)WoodworksBlocks.BIRCH_BEEHIVE.get(), (ItemLike)WoodworksBlocks.BIRCH_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_BIRCH_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.JUNGLE_PLANKS, (ItemLike)Blocks.JUNGLE_SLAB, (ItemLike)WoodworksBlocks.JUNGLE_BOARDS.get(), (ItemLike)WoodworksBlocks.JUNGLE_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_JUNGLE_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.JUNGLE_LADDER.get(), (ItemLike)WoodworksBlocks.JUNGLE_BEEHIVE.get(), (ItemLike)WoodworksBlocks.JUNGLE_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_JUNGLE_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.ACACIA_PLANKS, (ItemLike)Blocks.ACACIA_SLAB, (ItemLike)WoodworksBlocks.ACACIA_BOARDS.get(), (ItemLike)WoodworksBlocks.ACACIA_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_ACACIA_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.ACACIA_LADDER.get(), (ItemLike)WoodworksBlocks.ACACIA_BEEHIVE.get(), (ItemLike)WoodworksBlocks.ACACIA_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_ACACIA_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.DARK_OAK_PLANKS, (ItemLike)Blocks.DARK_OAK_SLAB, (ItemLike)WoodworksBlocks.DARK_OAK_BOARDS.get(), (ItemLike)WoodworksBlocks.DARK_OAK_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_DARK_OAK_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.DARK_OAK_LADDER.get(), (ItemLike)WoodworksBlocks.DARK_OAK_BEEHIVE.get(), (ItemLike)WoodworksBlocks.DARK_OAK_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_DARK_OAK_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.MANGROVE_PLANKS, (ItemLike)Blocks.MANGROVE_SLAB, (ItemLike)WoodworksBlocks.MANGROVE_BOARDS.get(), (ItemLike)WoodworksBlocks.MANGROVE_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_MANGROVE_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.MANGROVE_LADDER.get(), (ItemLike)WoodworksBlocks.MANGROVE_BEEHIVE.get(), (ItemLike)WoodworksBlocks.MANGROVE_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_MANGROVE_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.CHERRY_PLANKS, (ItemLike)Blocks.CHERRY_SLAB, (ItemLike)WoodworksBlocks.CHERRY_BOARDS.get(), (ItemLike)WoodworksBlocks.CHERRY_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_CHERRY_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHERRY_LADDER.get(), (ItemLike)WoodworksBlocks.CHERRY_BEEHIVE.get(), (ItemLike)WoodworksBlocks.CHERRY_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_CHERRY_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.BAMBOO_PLANKS, (ItemLike)Blocks.BAMBOO_SLAB, null, (ItemLike)WoodworksBlocks.BAMBOO_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_BAMBOO_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.BAMBOO_LADDER.get(), (ItemLike)WoodworksBlocks.BAMBOO_BEEHIVE.get(), (ItemLike)WoodworksBlocks.BAMBOO_CLOSET.get(), (ItemLike)WoodworksBlocks.TRAPPED_BAMBOO_CLOSET.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.CRIMSON_PLANKS, (ItemLike)Blocks.CRIMSON_SLAB, (ItemLike)WoodworksBlocks.CRIMSON_BOARDS.get(), (ItemLike)WoodworksBlocks.CRIMSON_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_CRIMSON_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CRIMSON_LADDER.get(), (ItemLike)WoodworksBlocks.CRIMSON_BEEHIVE.get(), (ItemLike)WoodworksBlocks.CRIMSON_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_CRIMSON_CHEST.get());
        WoodworksRecipeProvider.baseRecipes(output, (ItemLike)Blocks.WARPED_PLANKS, (ItemLike)Blocks.WARPED_SLAB, (ItemLike)WoodworksBlocks.WARPED_BOARDS.get(), (ItemLike)WoodworksBlocks.WARPED_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.CHISELED_WARPED_BOOKSHELF.get(), (ItemLike)WoodworksBlocks.WARPED_LADDER.get(), (ItemLike)WoodworksBlocks.WARPED_BEEHIVE.get(), (ItemLike)WoodworksBlocks.WARPED_CHEST.get(), (ItemLike)WoodworksBlocks.TRAPPED_WARPED_CHEST.get());
        WoodworksRecipeProvider.alternateStickRecipes(output, (ItemLike)Blocks.BAMBOO_PLANKS, (ItemLike)Blocks.BAMBOO_FENCE, (ItemLike)Blocks.BAMBOO_FENCE_GATE, (ItemLike)WoodworksBlocks.BAMBOO_LADDER.get(), Items.BAMBOO);
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.OAK_LEAVES, (ItemLike)WoodworksBlocks.OAK_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.SPRUCE_LEAVES, (ItemLike)WoodworksBlocks.SPRUCE_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.BIRCH_LEAVES, (ItemLike)WoodworksBlocks.BIRCH_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.JUNGLE_LEAVES, (ItemLike)WoodworksBlocks.JUNGLE_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.ACACIA_LEAVES, (ItemLike)WoodworksBlocks.ACACIA_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.DARK_OAK_LEAVES, (ItemLike)WoodworksBlocks.DARK_OAK_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.MANGROVE_LEAVES, (ItemLike)WoodworksBlocks.MANGROVE_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.CHERRY_LEAVES, (ItemLike)WoodworksBlocks.CHERRY_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.AZALEA_LEAVES, (ItemLike)WoodworksBlocks.AZALEA_LEAF_PILE.get());
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, (ItemLike)Blocks.FLOWERING_AZALEA_LEAVES, (ItemLike)WoodworksBlocks.FLOWERING_AZALEA_LEAF_PILE.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.OAK_PLANKS, (TagKey<Item>)ItemTags.OAK_LOGS, (ItemLike)WoodworksBlocks.OAK_BOARDS.get(), (ItemLike)Blocks.LADDER);
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.SPRUCE_PLANKS, (TagKey<Item>)ItemTags.SPRUCE_LOGS, (ItemLike)WoodworksBlocks.SPRUCE_BOARDS.get(), (ItemLike)WoodworksBlocks.SPRUCE_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.BIRCH_PLANKS, (TagKey<Item>)ItemTags.BIRCH_LOGS, (ItemLike)WoodworksBlocks.BIRCH_BOARDS.get(), (ItemLike)WoodworksBlocks.BIRCH_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.JUNGLE_PLANKS, (TagKey<Item>)ItemTags.JUNGLE_LOGS, (ItemLike)WoodworksBlocks.JUNGLE_BOARDS.get(), (ItemLike)WoodworksBlocks.JUNGLE_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.ACACIA_PLANKS, (TagKey<Item>)ItemTags.ACACIA_LOGS, (ItemLike)WoodworksBlocks.ACACIA_BOARDS.get(), (ItemLike)WoodworksBlocks.ACACIA_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.DARK_OAK_PLANKS, (TagKey<Item>)ItemTags.DARK_OAK_LOGS, (ItemLike)WoodworksBlocks.DARK_OAK_BOARDS.get(), (ItemLike)WoodworksBlocks.DARK_OAK_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.MANGROVE_PLANKS, (TagKey<Item>)ItemTags.MANGROVE_LOGS, (ItemLike)WoodworksBlocks.MANGROVE_BOARDS.get(), (ItemLike)WoodworksBlocks.MANGROVE_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.CHERRY_PLANKS, (TagKey<Item>)ItemTags.CHERRY_LOGS, (ItemLike)WoodworksBlocks.CHERRY_BOARDS.get(), (ItemLike)WoodworksBlocks.CHERRY_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.BAMBOO_PLANKS, (TagKey<Item>)ItemTags.BAMBOO_BLOCKS, (ItemLike)Blocks.BAMBOO_MOSAIC, (ItemLike)WoodworksBlocks.BAMBOO_LADDER.get(), true);
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.BAMBOO_MOSAIC, null, null, null);
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.CRIMSON_PLANKS, (TagKey<Item>)ItemTags.CRIMSON_STEMS, (ItemLike)WoodworksBlocks.CRIMSON_BOARDS.get(), (ItemLike)WoodworksBlocks.CRIMSON_LADDER.get());
        WoodworksRecipeProvider.sawmillRecipes(output, BlockFamilies.WARPED_PLANKS, (TagKey<Item>)ItemTags.WARPED_STEMS, (ItemLike)WoodworksBlocks.WARPED_BOARDS.get(), (ItemLike)WoodworksBlocks.WARPED_LADDER.get());
    }

    public static void baseRecipes(RecipeOutput output, ItemLike planks, ItemLike slab, ItemLike boards, ItemLike bookshelf, ItemLike chiseledBookshelf, ItemLike ladder, ItemLike beehive, ItemLike chest, ItemLike trappedChest) {
        WoodworksRecipeProvider.baseRecipes(output, planks, slab, boards, bookshelf, chiseledBookshelf, ladder, beehive, chest, trappedChest, "woodworks");
    }

    public static void baseRecipes(RecipeOutput output, ItemLike planks, ItemLike slab, ItemLike boards, ItemLike bookshelf, ItemLike chiseledBookshelf, ItemLike ladder, ItemLike beehive, ItemLike chest, ItemLike trappedChest, String modid) {
        String prefix;
        boolean compat = !modid.equals("woodworks");
        ConfigValueCondition boardsCondition = compat ? WoodworksConditions.compat(new ICondition[]{WoodworksConditions.WOODEN_BOARDS}) : WoodworksConditions.WOODEN_BOARDS;
        ConfigValueCondition bookshelfCondition = compat ? WoodworksConditions.compat(new ICondition[]{WoodworksConditions.WOODEN_BOOKSHELVES}) : WoodworksConditions.WOODEN_BOOKSHELVES;
        ConfigValueCondition ladderCondition = compat ? WoodworksConditions.compat(new ICondition[]{WoodworksConditions.WOODEN_LADDERS}) : WoodworksConditions.WOODEN_LADDERS;
        ConfigValueCondition beehiveCondition = compat ? WoodworksConditions.compat(new ICondition[]{WoodworksConditions.WOODEN_BEEHIVES}) : WoodworksConditions.WOODEN_BEEHIVES;
        ConfigValueCondition chestCondition = compat ? WoodworksConditions.compat(new ICondition[]{WoodworksConditions.WOODEN_CHESTS}) : WoodworksConditions.WOODEN_CHESTS;
        String string = prefix = planks == Blocks.OAK_PLANKS ? "oak_" : "";
        if (boards != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)boards).define(Character.valueOf('#'), slab).pattern("#").pattern("#").group("wooden_boards").unlockedBy(WoodworksRecipeProvider.getHasName((ItemLike)slab), WoodworksRecipeProvider.has((ItemLike)slab)).save(output.withConditions(new ICondition[]{boardsCondition}));
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bookshelf).define(Character.valueOf('#'), planks).define(Character.valueOf('X'), (ItemLike)Items.BOOK).pattern("###").pattern("XXX").pattern("###").group("wooden_bookshelf").unlockedBy("has_book", WoodworksRecipeProvider.has((ItemLike)Items.BOOK)).save(output.withConditions(new ICondition[]{bookshelfCondition}), ResourceLocation.fromNamespaceAndPath((String)modid, (String)(prefix + BuiltInRegistries.ITEM.getKey((Object)bookshelf.asItem()).getPath())));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)chiseledBookshelf).define(Character.valueOf('#'), planks).define(Character.valueOf('X'), slab).pattern("###").pattern("XXX").pattern("###").group("chiseled_wooden_bookshelf").unlockedBy("has_book", WoodworksRecipeProvider.has((ItemLike)Items.BOOK)).save(output.withConditions(new ICondition[]{bookshelfCondition}), ResourceLocation.fromNamespaceAndPath((String)modid, (String)(prefix + BuiltInRegistries.ITEM.getKey((Object)chiseledBookshelf.asItem()).getPath())));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladder, (int)4).define(Character.valueOf('#'), planks).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("S S").pattern("S#S").pattern("S S").group("wooden_ladder").unlockedBy("has_stick", WoodworksRecipeProvider.has((ItemLike)Items.STICK)).save(output.withConditions(new ICondition[]{ladderCondition}), ResourceLocation.fromNamespaceAndPath((String)modid, (String)(prefix + BuiltInRegistries.ITEM.getKey((Object)ladder.asItem()).getPath())));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)beehive).define(Character.valueOf('#'), planks).define(Character.valueOf('H'), (ItemLike)Items.HONEYCOMB).pattern("###").pattern("HHH").pattern("###").group("wooden_beehive").unlockedBy("has_honeycomb", WoodworksRecipeProvider.has((ItemLike)Items.HONEYCOMB)).save(output.withConditions(new ICondition[]{beehiveCondition}), ResourceLocation.fromNamespaceAndPath((String)modid, (String)(prefix + BuiltInRegistries.ITEM.getKey((Object)beehive.asItem()).getPath())));
        if (chest != null) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)chest).define(Character.valueOf('#'), planks).pattern("###").pattern("# #").pattern("###").group("wooden_chest").unlockedBy("has_lots_of_items", CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), new InventoryChangeTrigger.TriggerInstance.Slots(MinMaxBounds.Ints.atLeast((int)10), MinMaxBounds.Ints.ANY, MinMaxBounds.Ints.ANY), List.of()))).save(output.withConditions(new ICondition[]{chestCondition}));
        }
        if (trappedChest != null) {
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)trappedChest).requires(chest).requires((ItemLike)Blocks.TRIPWIRE_HOOK).group("wooden_trapped_chest").unlockedBy("has_tripwire_hook", WoodworksRecipeProvider.has((ItemLike)Blocks.TRIPWIRE_HOOK)).save(output.withConditions(new ICondition[]{chestCondition}));
        }
    }

    private static void alternateStickRecipes(RecipeOutput output, ItemLike planks, ItemLike fence, ItemLike fenceGate, ItemLike ladder, Item stick) {
        WoodworksRecipeProvider.alternateStickRecipes(output, planks, fence, fenceGate, ladder, stick, "woodworks");
    }

    public static void alternateStickRecipes(RecipeOutput output, ItemLike planks, ItemLike fence, ItemLike fenceGate, ItemLike ladder, Item stick, String modid) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fence, (int)3).define(Character.valueOf('W'), planks).define(Character.valueOf('#'), (ItemLike)stick).pattern("W#W").pattern("W#W").group("wooden_custom_fence").unlockedBy("has_planks", WoodworksRecipeProvider.has((ItemLike)planks)).save(output, WoodworksRecipeProvider.getConversionRecipeName(modid, fence, (ItemLike)stick));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)fenceGate).define(Character.valueOf('#'), (ItemLike)stick).define(Character.valueOf('W'), planks).pattern("#W#").pattern("#W#").group("wooden_custom_fence_gate").unlockedBy("has_planks", WoodworksRecipeProvider.has((ItemLike)planks)).save(output, WoodworksRecipeProvider.getConversionRecipeName(modid, fenceGate, (ItemLike)stick));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladder, (int)4).define(Character.valueOf('#'), planks).define(Character.valueOf('S'), (ItemLike)stick).pattern("S S").pattern("S#S").pattern("S S").group("wooden_ladder").unlockedBy("has_bamboo", WoodworksRecipeProvider.has((ItemLike)Items.BAMBOO)).save(output.withConditions(new ICondition[]{WoodworksConditions.WOODEN_LADDERS}), WoodworksRecipeProvider.getConversionRecipeName(modid, ladder, (ItemLike)stick));
    }

    public static void sawmillRecipes(RecipeOutput output, BlockFamily family, TagKey<Item> logs, ItemLike boards, ItemLike ladder) {
        WoodworksRecipeProvider.sawmillRecipes(output, family, logs, boards, ladder, false);
    }

    private static void sawmillRecipes(RecipeOutput output, BlockFamily family, TagKey<Item> logs, ItemLike boards, ItemLike ladder, boolean half) {
        WoodworksRecipeProvider.sawmillRecipes(output, family, logs, boards, ladder, "woodworks", half);
    }

    public static void sawmillRecipes(RecipeOutput output, BlockFamily family, TagKey<Item> logs, ItemLike boards, ItemLike ladder, String modid) {
        WoodworksRecipeProvider.sawmillRecipes(output, family, logs, boards, ladder, modid, false);
    }

    public static void sawmillRecipes(RecipeOutput output, BlockFamily family, TagKey<Item> logs, ItemLike boards, ItemLike ladder, String modid, boolean half) {
        Block fenceGate;
        boolean compat = !modid.equals("woodworks");
        boolean full = !half;
        Block planks = family.getBaseBlock();
        Block button = family.get(BlockFamily.Variant.BUTTON);
        Block door = family.get(BlockFamily.Variant.DOOR);
        Block fence = family.get(BlockFamily.Variant.FENCE);
        if (fence == null) {
            fence = family.get(BlockFamily.Variant.CUSTOM_FENCE);
        }
        if ((fenceGate = family.get(BlockFamily.Variant.FENCE_GATE)) == null) {
            fenceGate = family.get(BlockFamily.Variant.CUSTOM_FENCE_GATE);
        }
        Block pressurePlate = family.get(BlockFamily.Variant.PRESSURE_PLATE);
        Block sign = family.get(BlockFamily.Variant.SIGN);
        Block slab = family.get(BlockFamily.Variant.SLAB);
        Block stairs = family.get(BlockFamily.Variant.STAIRS);
        Block trapdoor = family.get(BlockFamily.Variant.TRAPDOOR);
        ConfigValueCondition sawmillCondition = compat ? WoodworksConditions.compat(new ICondition[]{WoodworksConditions.SAWMILL_ENABLED}) : WoodworksConditions.SAWMILL_ENABLED;
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, logs, (ItemLike)planks, full ? 4 : 2, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, (ItemLike)planks, (ItemLike)button, 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)button, full ? 4 : 2, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)door, full ? 2 : 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.DECORATIONS, (ItemLike)planks, (ItemLike)fence, 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.DECORATIONS, logs, (ItemLike)fence, full ? 4 : 2, "", modid);
        if (full) {
            WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)fenceGate, 1, "", modid);
        }
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)pressurePlate, full ? 2 : 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.DECORATIONS, logs, (ItemLike)sign, full ? 2 : 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (ItemLike)slab, 2, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, logs, (ItemLike)slab, full ? 8 : 4, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, (ItemLike)stairs, 1, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.BUILDING_BLOCKS, logs, (ItemLike)stairs, full ? 4 : 2, "", modid);
        WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)sawmillCondition, RecipeCategory.REDSTONE, logs, (ItemLike)trapdoor, full ? 2 : 1, "", modid);
        if (boards != null) {
            BlueprintAndCondition boardsCondition = compat ? WoodworksConditions.compat(new ICondition[]{WoodworksConditions.SAWMILL_ENABLED, WoodworksConditions.WOODEN_BOARDS}) : new BlueprintAndCondition(new ICondition[]{WoodworksConditions.SAWMILL_ENABLED, WoodworksConditions.WOODEN_BOARDS});
            WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)boardsCondition, RecipeCategory.BUILDING_BLOCKS, (ItemLike)planks, boards, 1, "", modid);
            WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)boardsCondition, RecipeCategory.BUILDING_BLOCKS, logs, boards, full ? 4 : 2, "", modid);
        }
        if (ladder != null) {
            BlueprintAndCondition ladderCondition = compat ? WoodworksConditions.compat(new ICondition[]{WoodworksConditions.SAWMILL_ENABLED, WoodworksConditions.WOODEN_LADDERS}) : new BlueprintAndCondition(new ICondition[]{WoodworksConditions.SAWMILL_ENABLED, WoodworksConditions.WOODEN_LADDERS});
            String prefix = planks == Blocks.OAK_PLANKS ? "oak_" : "";
            WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)ladderCondition, RecipeCategory.DECORATIONS, (ItemLike)planks, ladder, 1, prefix, modid);
            WoodworksRecipeProvider.sawmillRecipe(output, (ICondition)ladderCondition, RecipeCategory.DECORATIONS, logs, ladder, full ? 4 : 2, prefix, modid);
        }
    }

    private static void conditionalLeafPileRecipes(RecipeOutput output, ItemLike leaves, ItemLike leafPile) {
        WoodworksRecipeProvider.conditionalLeafPileRecipes(output, leaves, leafPile, "woodworks");
    }

    public static void conditionalLeafPileRecipes(RecipeOutput output, ItemLike leaves, ItemLike leafPile, String modid) {
        ConfigValueCondition condition = modid.equals("woodworks") ? WoodworksConditions.LEAF_PILES : WoodworksConditions.compat(new ICondition[]{WoodworksConditions.LEAF_PILES});
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leafPile, (int)4).requires(leaves).group("leaf_pile").unlockedBy(WoodworksRecipeProvider.getHasName((ItemLike)leaves), WoodworksRecipeProvider.has((ItemLike)leaves)).save(output.withConditions(new ICondition[]{condition}));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)leaves).define(Character.valueOf('#'), leafPile).pattern("##").pattern("##").group("leaves").unlockedBy(WoodworksRecipeProvider.getHasName((ItemLike)leafPile), WoodworksRecipeProvider.has((ItemLike)leafPile)).save(output.withConditions(new ICondition[]{condition}), WoodworksRecipeProvider.getConversionRecipeName(modid, leaves, leafPile));
    }

    public static void sawmillRecipe(RecipeOutput output, ICondition condition, RecipeCategory recipeCategory, ItemLike input, ItemLike result, int count) {
        WoodworksRecipeProvider.sawmillRecipe(output, condition, recipeCategory, input, result, count, "");
    }

    public static void sawmillRecipe(RecipeOutput output, ICondition condition, RecipeCategory recipeCategory, ItemLike input, ItemLike result, int count, String prefix) {
        WoodworksRecipeProvider.sawmillRecipe(output, condition, recipeCategory, input, result, count, prefix, "woodworks");
    }

    public static void sawmillRecipe(RecipeOutput output, ICondition condition, RecipeCategory recipeCategory, ItemLike input, ItemLike result, int count, String prefix, String modid) {
        if (input != null && result != null) {
            WoodworksRecipeProvider.sawmillResultFromBase(recipeCategory, result, input, count).save(output.withConditions(new ICondition[]{condition}), WoodworksRecipeProvider.getConversionRecipeName(modid, result, input).withPrefix(prefix).withSuffix("_sawing"));
        }
    }

    public static void sawmillRecipe(RecipeOutput output, ICondition condition, RecipeCategory recipeCategory, TagKey<Item> input, ItemLike result, int count) {
        WoodworksRecipeProvider.sawmillRecipe(output, condition, recipeCategory, input, result, count, "");
    }

    private static void sawmillRecipe(RecipeOutput output, ICondition condition, RecipeCategory recipeCategory, TagKey<Item> input, ItemLike result, int count, String prefix) {
        WoodworksRecipeProvider.sawmillRecipe(output, condition, recipeCategory, input, result, count, prefix, "woodworks");
    }

    public static void sawmillRecipe(RecipeOutput output, ICondition condition, RecipeCategory recipeCategory, TagKey<Item> input, ItemLike result, int count, String prefix, String modid) {
        if (input != null && result != null) {
            WoodworksRecipeProvider.sawmillResultFromBase(recipeCategory, result, input, count).save(output.withConditions(new ICondition[]{condition}), WoodworksRecipeProvider.getConversionRecipeName(modid, result, input).withPrefix(prefix).withSuffix("_sawing"));
        }
    }

    public static SingleItemRecipeBuilder sawing(RecipeCategory recipeCategory, Ingredient ingredient, ItemLike result, int count) {
        return new SingleItemRecipeBuilder(recipeCategory, SawmillRecipe::new, ingredient, result, count);
    }

    protected static SingleItemRecipeBuilder sawmillResultFromBase(RecipeCategory recipeCategory, ItemLike result, ItemLike input, int count) {
        return WoodworksRecipeProvider.sawing(recipeCategory, Ingredient.of((ItemLike[])new ItemLike[]{input}), result, count).unlockedBy(WoodworksRecipeProvider.getHasName((ItemLike)input), WoodworksRecipeProvider.has((ItemLike)input));
    }

    protected static SingleItemRecipeBuilder sawmillResultFromBase(RecipeCategory recipeCategory, ItemLike result, TagKey<Item> input, int count) {
        return WoodworksRecipeProvider.sawing(recipeCategory, Ingredient.of(input), result, count).unlockedBy("has_" + input.location().getPath(), WoodworksRecipeProvider.has(input));
    }

    protected static String getConversionRecipeName(ItemLike result, TagKey<Item> input) {
        return WoodworksRecipeProvider.getItemName((ItemLike)result) + "_from_" + input.location().getPath();
    }

    public static ResourceLocation getConversionRecipeName(String modid, ItemLike result, ItemLike input) {
        return ResourceLocation.fromNamespaceAndPath((String)modid, (String)WoodworksRecipeProvider.getConversionRecipeName((ItemLike)result, (ItemLike)input));
    }

    public static ResourceLocation getConversionRecipeName(String modid, ItemLike result, TagKey<Item> input) {
        return ResourceLocation.fromNamespaceAndPath((String)modid, (String)WoodworksRecipeProvider.getConversionRecipeName(result, input));
    }
}

