/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.other;

import com.teamabnormals.woodworks.client.renderer.block.DrawerBlockEntityRenderer;
import com.teamabnormals.woodworks.core.Woodworks;
import com.teamabnormals.woodworks.core.registry.WoodworksBlockEntityTypes;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(modid="woodworks", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class WoodworksModelLayers {
    public static final ModelLayerLocation BAMBOO_CLOSET_LEFT = WoodworksModelLayers.register("bamboo_closet_left");
    public static final ModelLayerLocation BAMBOO_CLOSET_TALL_LEFT = WoodworksModelLayers.register("bamboo_closet_tall_left");
    public static final ModelLayerLocation BAMBOO_CLOSET_RIGHT = WoodworksModelLayers.register("bamboo_closet_right");
    public static final ModelLayerLocation BAMBOO_CLOSET_TALL_RIGHT = WoodworksModelLayers.register("bamboo_closet_tall_right");

    public static ModelLayerLocation register(String name) {
        return WoodworksModelLayers.register(name, "main");
    }

    public static ModelLayerLocation register(String name, String layer) {
        return new ModelLayerLocation(Woodworks.location(name), layer);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BAMBOO_CLOSET_LEFT, () -> DrawerBlockEntityRenderer.createBodyLayer(false, false));
        event.registerLayerDefinition(BAMBOO_CLOSET_RIGHT, () -> DrawerBlockEntityRenderer.createBodyLayer(false, true));
        event.registerLayerDefinition(BAMBOO_CLOSET_TALL_LEFT, () -> DrawerBlockEntityRenderer.createBodyLayer(true, false));
        event.registerLayerDefinition(BAMBOO_CLOSET_TALL_RIGHT, () -> DrawerBlockEntityRenderer.createBodyLayer(true, true));
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)WoodworksBlockEntityTypes.CLOSET.get(), DrawerBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)WoodworksBlockEntityTypes.TRAPPED_CLOSET.get(), DrawerBlockEntityRenderer::new);
    }
}

