/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.registry.datapack;

import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.woodworks.core.Woodworks;
import com.teamabnormals.woodworks.core.other.WoodworksConditions;
import com.teamabnormals.woodworks.core.registry.WoodworksBlocks;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.common.conditions.ICondition;

public class WoodworksStructureRepaletters {
    public static final ResourceKey<StructureRepaletterEntry> OAK_CHESTS_IN_VILLAGES = WoodworksStructureRepaletters.create("oak_chests_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> SPRUCE_CHESTS_IN_VILLAGES = WoodworksStructureRepaletters.create("spruce_chests_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> JUNGLE_CHESTS_IN_VILLAGES = WoodworksStructureRepaletters.create("jungle_chests_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> ACACIA_CHESTS_IN_VILLAGES = WoodworksStructureRepaletters.create("acacia_chests_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> SPRUCE_BOOKSHELVES_IN_VILLAGES = WoodworksStructureRepaletters.create("spruce_bookshelves_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> JUNGLE_BOOKSHELVES_IN_VILLAGES = WoodworksStructureRepaletters.create("jungle_bookshelves_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> ACACIA_BOOKSHELVES_IN_VILLAGES = WoodworksStructureRepaletters.create("acacia_bookshelves_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> SPRUCE_LADDERS_IN_VILLAGES = WoodworksStructureRepaletters.create("spruce_ladders_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> JUNGLE_LADDERS_IN_VILLAGES = WoodworksStructureRepaletters.create("jungle_ladders_in_villages");
    public static final ResourceKey<StructureRepaletterEntry> ACACIA_LADDERS_IN_VILLAGES = WoodworksStructureRepaletters.create("acacia_ladders_in_villages");

    public static void bootstrap(BootstrapContext<StructureRepaletterEntry> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, OAK_CHESTS_IN_VILLAGES, Blocks.CHEST, (Block)WoodworksBlocks.OAK_CHEST.get(), BuiltinStructures.VILLAGE_PLAINS);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, SPRUCE_CHESTS_IN_VILLAGES, Blocks.CHEST, (Block)WoodworksBlocks.SPRUCE_CHEST.get(), BuiltinStructures.VILLAGE_TAIGA, BuiltinStructures.VILLAGE_SNOWY);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, JUNGLE_CHESTS_IN_VILLAGES, Blocks.CHEST, (Block)WoodworksBlocks.JUNGLE_CHEST.get(), BuiltinStructures.VILLAGE_DESERT);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, ACACIA_CHESTS_IN_VILLAGES, Blocks.CHEST, (Block)WoodworksBlocks.ACACIA_CHEST.get(), BuiltinStructures.VILLAGE_SAVANNA);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, SPRUCE_BOOKSHELVES_IN_VILLAGES, Blocks.BOOKSHELF, (Block)WoodworksBlocks.SPRUCE_BOOKSHELF.get(), BuiltinStructures.VILLAGE_TAIGA, BuiltinStructures.VILLAGE_SNOWY);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, JUNGLE_BOOKSHELVES_IN_VILLAGES, Blocks.BOOKSHELF, (Block)WoodworksBlocks.JUNGLE_BOOKSHELF.get(), BuiltinStructures.VILLAGE_DESERT);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, ACACIA_BOOKSHELVES_IN_VILLAGES, Blocks.BOOKSHELF, (Block)WoodworksBlocks.ACACIA_BOOKSHELF.get(), BuiltinStructures.VILLAGE_SAVANNA);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, SPRUCE_LADDERS_IN_VILLAGES, Blocks.LADDER, (Block)WoodworksBlocks.SPRUCE_LADDER.get(), BuiltinStructures.VILLAGE_TAIGA, BuiltinStructures.VILLAGE_SNOWY);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, JUNGLE_LADDERS_IN_VILLAGES, Blocks.LADDER, (Block)WoodworksBlocks.JUNGLE_LADDER.get(), BuiltinStructures.VILLAGE_DESERT);
        WoodworksStructureRepaletters.register(context, (HolderGetter<Structure>)structures, ACACIA_LADDERS_IN_VILLAGES, Blocks.LADDER, (Block)WoodworksBlocks.ACACIA_LADDER.get(), BuiltinStructures.VILLAGE_SAVANNA);
    }

    public static void applyConditions(BiConsumer<ResourceKey<?>, ICondition> builder) {
        builder.accept(OAK_CHESTS_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_CHESTS_IN_VILLAGES);
        builder.accept(SPRUCE_CHESTS_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_CHESTS_IN_VILLAGES);
        builder.accept(JUNGLE_CHESTS_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_CHESTS_IN_VILLAGES);
        builder.accept(ACACIA_CHESTS_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_CHESTS_IN_VILLAGES);
        builder.accept(SPRUCE_BOOKSHELVES_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_BOOKSHELVES_IN_VILLAGES);
        builder.accept(JUNGLE_BOOKSHELVES_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_BOOKSHELVES_IN_VILLAGES);
        builder.accept(ACACIA_BOOKSHELVES_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_BOOKSHELVES_IN_VILLAGES);
        builder.accept(SPRUCE_LADDERS_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_LADDERS_IN_VILLAGES);
        builder.accept(JUNGLE_LADDERS_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_LADDERS_IN_VILLAGES);
        builder.accept(ACACIA_LADDERS_IN_VILLAGES, (ICondition)WoodworksConditions.WOODEN_LADDERS_IN_VILLAGES);
    }

    @SafeVarargs
    private static void register(BootstrapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ResourceKey<StructureRepaletterEntry> key, Block replacesBlock, Block replacesWith, ResourceKey<Structure> ... keys) {
        context.register(key, (Object)StructureRepaletterEntry.repalette().repaletters(new StructureRepaletter[]{StructureRepaletterEntry.simple((Block)replacesBlock, (Block)replacesWith)}).select(StructureRepaletterEntry.holder(structures, keys)));
    }

    private static ResourceKey<StructureRepaletterEntry> create(String name) {
        return ResourceKey.create((ResourceKey)BlueprintDataPackRegistries.STRUCTURE_REPALETTERS, (ResourceLocation)Woodworks.location(name));
    }
}

