/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.woodworks.core.registry.helper;

import com.teamabnormals.blueprint.client.BlueprintChestMaterials;
import com.teamabnormals.blueprint.client.MemoizedBEWLR;
import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamabnormals.woodworks.client.renderer.block.DrawerBlockEntityWithoutLevelRenderer;
import com.teamabnormals.woodworks.common.block.ClosetBlock;
import com.teamabnormals.woodworks.common.block.TrappedClosetBlock;
import com.teamabnormals.woodworks.common.block.entity.ClosetBlockEntity;
import com.teamabnormals.woodworks.common.block.entity.TrappedClosetBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class WoodworksBlockSubRegistryHelper
extends BlockSubRegistryHelper {
    public WoodworksBlockSubRegistryHelper(RegistryHelper parent) {
        super(parent);
    }

    public DeferredBlock<ClosetBlock> createClosetBlock(String name, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials((String)modId, (String)name, (boolean)false);
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register(name + "_closet", () -> new ClosetBlock(chestMaterialsName, properties));
        DeferredHolder item = this.itemRegister.register(name + "_closet", () -> new BlockItem((Block)block.get(), new Item.Properties()));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientItemExtensions.put(item, WoodworksBlockSubRegistryHelper.closetBEWLRItemExtensions((Supplier<? extends Block>)block, false));
        }
        return block;
    }

    public DeferredBlock<TrappedClosetBlock> createTrappedClosetBlock(String name, BlockBehaviour.Properties properties) {
        String modId = this.parent.getModId();
        String chestMaterialsName = BlueprintChestMaterials.registerMaterials((String)modId, (String)name, (boolean)true);
        DeferredBlock block = ((DeferredRegister.Blocks)this.deferredRegister).register("trapped_" + name + "_closet", () -> new TrappedClosetBlock(chestMaterialsName, properties));
        DeferredHolder item = this.itemRegister.register("trapped_" + name + "_closet", () -> new BlockItem((Block)block.get(), new Item.Properties()));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientItemExtensions.put(item, WoodworksBlockSubRegistryHelper.closetBEWLRItemExtensions((Supplier<? extends Block>)block, true));
        }
        return block;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static IClientItemExtensions closetBEWLRItemExtensions(Supplier<? extends Block> block, boolean trapped) {
        return MemoizedBEWLR.asCustomItemRenderer((MemoizedBEWLR.Factory)(trapped ? (dispatcher, entityModelSet) -> new DrawerBlockEntityWithoutLevelRenderer<TrappedClosetBlockEntity>(dispatcher, entityModelSet, new TrappedClosetBlockEntity(BlockPos.ZERO, ((Block)block.get()).defaultBlockState())) : (dispatcher, entityModelSet) -> new DrawerBlockEntityWithoutLevelRenderer<ClosetBlockEntity>(dispatcher, entityModelSet, new ClosetBlockEntity(BlockPos.ZERO, ((Block)block.get()).defaultBlockState()))));
    }
}

