/*
 * Decompiled with CFR 0.152.
 */
package org.cfg;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class fokusapi
extends JavaPlugin {
    private static final String DATAPACK_URL = "https://cdn.modrinth.com/data/rvZnCrhx/versions/aVHlDg4g/FokusAPI-v3.0_DATAPACK.zip";
    private static final String DATAPACK_FOLDER = "datapacks";
    private static final String DATAPACK_FILE = "FokusAPI-3.0.zip";

    public void onEnable() {
        this.getLogger().info("DatapackDownloader Plugin Enabled!");
        boolean downloaded = this.downloadDatapack();
        if (downloaded) {
            this.enableDatapack();
        }
    }

    private boolean downloadDatapack() {
        File worldFolder = ((World)Bukkit.getWorlds().get(0)).getWorldFolder();
        File datapackFolder = new File(worldFolder, DATAPACK_FOLDER);
        File datapackFile = new File(datapackFolder, DATAPACK_FILE);
        if (!datapackFolder.exists()) {
            if (datapackFolder.mkdirs()) {
                this.getLogger().info("Created datapacks folder.");
            } else {
                this.getLogger().severe("Failed to create datapacks folder.");
                return false;
            }
        }
        if (datapackFile.exists()) {
            this.getLogger().info("Datapack already exists. Skipping download.");
            return false;
        }
        try {
            this.getLogger().info("Downloading datapack...");
            URL url = new URL(DATAPACK_URL);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            try (InputStream in = connection.getInputStream();){
                Files.copy(in, Paths.get(datapackFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                this.getLogger().info("Datapack downloaded successfully.");
            }
            return true;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Failed to download datapack", e);
            return false;
        }
    }

    private void enableDatapack() {
        this.getLogger().info("Enabling datapack...");
        String command = "datapack enable \"file/FokusAPI-3.0.zip\"";
        Bukkit.getScheduler().runTask((Plugin)this, () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"datapack list"));
        Bukkit.getScheduler().runTask((Plugin)this, () -> {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            this.getLogger().info("Datapack enabled using command: " + command);
        });
    }
}

