/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.argument.named;

import com.google.common.collect.ImmutableMap;
import dev.triumphteam.cmd.core.argument.named.Arguments;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class NamedArgumentResult
implements Arguments {
    private final Map<String, Object> values;

    public NamedArgumentResult(@NotNull @NotNull Map<@NotNull String, @NotNull Object> values) {
        this.values = values;
    }

    @Override
    @NotNull
    public <T> Optional<T> get(@NotNull String name, @NotNull Class<T> type) {
        return Optional.ofNullable(this.values.get(name));
    }

    @Override
    @NotNull
    public <T> Optional<List<T>> getAsList(@NotNull String name, @NotNull Class<T> type) {
        List value = (List)this.values.get(name);
        return Optional.ofNullable(value);
    }

    @Override
    @NotNull
    public <T> Optional<Set<T>> getAsSet(@NotNull String name, @NotNull Class<T> type) {
        Set value = (Set)this.values.get(name);
        return Optional.ofNullable(value);
    }

    @Override
    @NotNull
    public Map<String, Object> getArguments() {
        return ImmutableMap.copyOf(this.values);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @NotNull
    public String toString() {
        return "Arguments{values=" + this.values + '}';
    }
}

