/*
 * Decompiled with CFR 0.152.
 */
package dev.triumphteam.cmd.core.flag.internal;

import dev.triumphteam.cmd.core.flag.internal.FlagOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlagGroup<S> {
    private final Map<String, FlagOptions<S>> flags = new HashMap<String, FlagOptions<S>>();
    private final Map<String, FlagOptions<S>> longFlags = new HashMap<String, FlagOptions<S>>();
    private final List<String> allFlags = new ArrayList<String>();

    @NotNull
    public @NotNull Map<@Nullable String, @NotNull FlagOptions<S>> getFlags() {
        return this.flags;
    }

    @NotNull
    public @NotNull Map<@NotNull String, @NotNull FlagOptions<S>> getLongFlags() {
        return this.longFlags;
    }

    public void addFlag(@NotNull FlagOptions<S> flagOptions) {
        String key = flagOptions.getKey();
        String longFlag = flagOptions.getLongFlag();
        if (longFlag != null) {
            this.allFlags.add("--" + longFlag);
            this.longFlags.put(longFlag, flagOptions);
        }
        this.allFlags.add("-" + key);
        this.flags.put(key, flagOptions);
    }

    @NotNull
    public @NotNull List<@NotNull String> getAllFlags() {
        return this.allFlags;
    }

    public boolean isEmpty() {
        return this.flags.isEmpty() && this.longFlags.isEmpty();
    }

    @Nullable
    public FlagOptions<S> getMatchingFlag(@NotNull String token) {
        String stripped = this.stripLeadingHyphens(token);
        FlagOptions<S> flag = this.flags.get(stripped);
        return flag != null ? flag : this.longFlags.get(stripped);
    }

    @NotNull
    private String stripLeadingHyphens(@NotNull String token) {
        if (token.startsWith("--")) {
            return token.substring(2);
        }
        if (token.startsWith("-")) {
            return token.substring(1);
        }
        return token;
    }
}

