/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard;

import java.sql.SQLException;
import java.util.logging.Logger;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.conditions.ConditionManager;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.config.RSBScoreboards;
import joserodpt.realscoreboard.api.managers.DatabaseManagerAPI;
import joserodpt.realscoreboard.api.managers.ScoreboardManagerAPI;
import joserodpt.realscoreboard.api.scoreboard.RSBPlayer;
import joserodpt.realscoreboard.api.utils.IPlaceholders;
import joserodpt.realscoreboard.managers.AnimationManagerAPI;
import joserodpt.realscoreboard.managers.PlayerManagerAPI;
import joserodpt.realscoreboard.utils.Placeholders;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public class RealScoreboard
extends RealScoreboardAPI {
    private joserodpt.realscoreboard.managers.DatabaseManagerAPI databaseManager;
    private final joserodpt.realscoreboard.managers.ScoreboardManagerAPI scoreboardManager;
    private final PlayerManagerAPI playerManager;
    private final AnimationManagerAPI animationManager;
    private final ConditionManager conditionManager;
    private final Logger logger;
    private final IPlaceholders placeholders;
    private final JavaPlugin plugin;

    public RealScoreboard(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.playerManager = new PlayerManagerAPI(this);
        this.conditionManager = new ConditionManager(this);
        this.placeholders = new Placeholders(this);
        this.scoreboardManager = new joserodpt.realscoreboard.managers.ScoreboardManagerAPI(this, this.conditionManager);
        try {
            this.databaseManager = new joserodpt.realscoreboard.managers.DatabaseManagerAPI(plugin);
        }
        catch (SQLException ex) {
            this.getLogger().severe("Error while starting the Database Manager!");
            this.getLogger().severe(ex.getMessage());
        }
        this.animationManager = new AnimationManagerAPI(plugin);
    }

    @Override
    public ScoreboardManagerAPI getScoreboardManagerAPI() {
        return this.scoreboardManager;
    }

    @Override
    public DatabaseManagerAPI getDatabaseManagerAPI() {
        return this.databaseManager;
    }

    @Override
    public joserodpt.realscoreboard.api.managers.PlayerManagerAPI getPlayerManagerAPI() {
        return this.playerManager;
    }

    @Override
    public AnimationManagerAPI getAnimationManagerAPI() {
        return this.animationManager;
    }

    @Override
    public void reload() {
        RSBConfig.reload();
        RSBScoreboards.reload();
        this.playerManager.getPlayerMap().values().forEach(RSBPlayer::stopScoreboard);
        this.scoreboardManager.reload();
        this.playerManager.getPlayerMap().values().forEach(RSBPlayer::stopScoreboard);
        this.playerManager.getPlayerMap().clear();
        Bukkit.getOnlinePlayers().forEach(this.playerManager::initPlayer);
    }

    @Override
    public ConditionManager getConditionManager() {
        return this.conditionManager;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public IPlaceholders getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public JavaPlugin getPlugin() {
        return this.plugin;
    }
}

