/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard;

import dev.triumphteam.cmd.bukkit.BukkitCommandManager;
import dev.triumphteam.cmd.bukkit.message.BukkitMessageKey;
import dev.triumphteam.cmd.core.BaseCommand;
import dev.triumphteam.cmd.core.message.MessageKey;
import dev.triumphteam.cmd.core.suggestion.SuggestionKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import joserodpt.realpermissions.api.RealPermissionsAPI;
import joserodpt.realpermissions.api.pluginhook.ExternalPlugin;
import joserodpt.realpermissions.api.pluginhook.ExternalPluginPermission;
import joserodpt.realscoreboard.RealScoreboard;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.config.RSBScoreboards;
import joserodpt.realscoreboard.api.scoreboard.RScoreboard;
import joserodpt.realscoreboard.api.utils.GUIBuilder;
import joserodpt.realscoreboard.api.utils.Text;
import joserodpt.realscoreboard.commands.BaseCommandWA;
import joserodpt.realscoreboard.commands.RealScoreboardCommand;
import joserodpt.realscoreboard.gui.SettingsGUI;
import joserodpt.realscoreboard.listeners.McMMOScoreboardListener;
import joserodpt.realscoreboard.listeners.PlayerListener;
import joserodpt.realscoreboard.utils.Metrics;
import joserodpt.realscoreboard.utils.UpdateChecker;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class RealScoreboardPlugin
extends JavaPlugin {
    private Permission perms;
    private Economy economy;
    private Chat chat;
    private static RealScoreboardPlugin instance;
    private static RealScoreboard realScoreboard;
    private boolean placeholderAPI = false;
    private static Boolean newUpdate;

    public void onEnable() {
        this.printASCII();
        new Metrics((Plugin)this, 10080);
        long start = System.currentTimeMillis();
        RSBConfig.setup(this);
        RSBScoreboards.setup(this);
        instance = this;
        realScoreboard = new RealScoreboard(this);
        RealScoreboardAPI.setInstance(realScoreboard);
        realScoreboard.getScoreboardManagerAPI().loadScoreboards();
        if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            this.setupEconomy();
            this.setupPermissions();
            this.setupChat();
        } else {
            this.getLogger().warning("Vault is not installed on the server.");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.placeholderAPI = true;
        } else {
            this.getLogger().warning("PlaceholderAPI is not installed on the server.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(realScoreboard), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(SettingsGUI.getListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents(GUIBuilder.getListener(), (Plugin)this);
        BukkitCommandManager<CommandSender> commandManager = BukkitCommandManager.create((Plugin)this);
        commandManager.registerSuggestion(SuggestionKey.of("#scoreboards"), (sender, context) -> realScoreboard.getScoreboardManagerAPI().getScoreboards().stream().map(RScoreboard::getName).collect(Collectors.toList()));
        HashMap<String, BaseCommandWA> commands = new HashMap<String, BaseCommandWA>();
        this.registerCommand("realscoreboard", new RealScoreboardCommand(realScoreboard), commands, commandManager);
        commandManager.registerMessage(BukkitMessageKey.NO_PERMISSION, (sender, context) -> Text.send(sender, "&cYou don't have permission to execute this command!"));
        commandManager.registerMessage(MessageKey.UNKNOWN_COMMAND, (sender, context) -> Text.send(sender, "&cThe command you're trying to run doesn't exist."));
        commandManager.registerMessage(MessageKey.NOT_ENOUGH_ARGUMENTS, (sender, context) -> {
            Bukkit.getLogger().warning(context.getCommand() + " " + context.getSubCommand());
            Text.send(sender, ((BaseCommandWA)commands.get(context.getCommand())).getWrongUsage(context.getSubCommand()));
        });
        if (RSBConfig.file().getBoolean("Config.mcMMO-Support").booleanValue() && Bukkit.getPluginManager().isPluginEnabled("mcMMO")) {
            Bukkit.getPluginManager().registerEvents((Listener)new McMMOScoreboardListener(realScoreboard), (Plugin)this);
        }
        if (RSBConfig.file().getBoolean("Config.Check-for-Updates").booleanValue()) {
            new UpdateChecker(this, 22928).getVersion((Consumer<String>)((Consumer)version -> {
                if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                    this.getLogger().info("The plugin is updated to the latest version.");
                } else {
                    newUpdate = true;
                    this.getLogger().warning("There is a new update available! https://www.spigotmc.org/resources/22928/");
                }
            }));
        }
        if (this.getServer().getPluginManager().getPlugin("RealPermissions") != null) {
            try {
                ArrayList<ExternalPluginPermission> perms = new ArrayList<ExternalPluginPermission>(Arrays.asList(new ExternalPluginPermission("realscoreboard.admin", "Allow access to the main operator commands of RealScoreboard.", Arrays.asList("rsb config", "rsb debug", "rsb reload")), new ExternalPluginPermission("realscoreboard.setscoreboard", "Allow access to the setscoreboard command of RealScoreboard.", Collections.singletonList("rsb view <name> <target?>")), new ExternalPluginPermission("realscoreboard.toggle", "Allow permission to toggle the scoreboard.", Arrays.asList("rsb on", "rsb off", "rsb toggle", "rsb t"))));
                realScoreboard.getScoreboardManagerAPI().getScoreboards().stream().filter(rScoreboard -> !rScoreboard.getPermission().equalsIgnoreCase("none")).forEach(rScoreboard -> perms.add(new ExternalPluginPermission(rScoreboard.getPermission(), "Permission for viewing the scoreboard: " + rScoreboard.getDisplayName())));
                RealPermissionsAPI.getInstance().getHooksAPI().addHook(new ExternalPlugin(this.getDescription().getName(), "&fReal&dScoreboard", this.getDescription().getDescription(), Material.PAINTING, perms, realScoreboard.getVersion()));
            }
            catch (Exception e) {
                this.getLogger().warning("Error while trying to register RealScoreboard permissions onto RealPermissions.");
                e.printStackTrace();
            }
        }
        Arrays.asList("Server version: " + this.getServerVersion(), "Finished loading in " + (float)(System.currentTimeMillis() - start) / 1000.0f + " seconds.").forEach(s -> this.getLogger().info((String)s));
        this.getLogger().info("<------------------ RealScoreboard vPT ------------------>".replace("PT", this.getDescription().getVersion()));
    }

    private void registerCommand(String realmines, BaseCommandWA mineCMD, Map<String, BaseCommandWA> commands, BukkitCommandManager<CommandSender> commandManager) {
        commands.put(realmines, mineCMD);
        commandManager.registerCommand((BaseCommand)mineCMD);
    }

    private void printASCII() {
        this.logWithColor("&d   ____            _ ____                     _                         _");
        this.logWithColor("&d  |  _ \\ ___  __ _| / ___|  ___ ___  _ __ ___| |__   ___   __ _ _ __ __| |");
        this.logWithColor("&d  | |_) / _ \\/ _` | \\___ \\ / __/ _ \\| '__/ _ \\ '_ \\ / _ \\ / _` | '__/ _` |");
        this.logWithColor("&d  |  _ <  __/ (_| | |___) | (_| (_) | | |  __/ |_) | (_) | (_| | | | (_| |");
        this.logWithColor("&d  |_| \\_\\___|\\__,_|_|____/ \\___\\___/|_|  \\___|_.__/ \\___/ \\__,_|_|  \\__,_|");
        this.logWithColor("  &8Made by: &9JoseGamer_PT \t\t                      &8Version: &9" + this.getVersion());
        this.getLogger().info("");
    }

    public void logWithColor(String s) {
        this.getServer().getConsoleSender().sendMessage("[" + this.getDescription().getName() + "] " + Text.color(s));
    }

    private void setupEconomy() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return;
        }
        this.economy = (Economy)rsp.getProvider();
    }

    private void setupPermissions() {
        RegisteredServiceProvider permissionProvider = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (permissionProvider != null) {
            this.perms = (Permission)permissionProvider.getProvider();
        }
    }

    private void setupChat() {
        RegisteredServiceProvider chatProvider = this.getServer().getServicesManager().getRegistration(Chat.class);
        if (chatProvider != null) {
            this.chat = (Chat)chatProvider.getProvider();
        }
    }

    public String getServerVersion() {
        return Bukkit.getServer().getBukkitVersion();
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    public Permission getPerms() {
        return this.perms;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Chat getChat() {
        return this.chat;
    }

    public static RealScoreboardPlugin getInstance() {
        return instance;
    }

    public boolean isPlaceholderAPI() {
        return this.placeholderAPI;
    }

    public static Boolean getNewUpdate() {
        return newUpdate;
    }

    static {
        newUpdate = false;
    }
}

