/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api;

import com.google.common.base.Preconditions;
import java.util.logging.Logger;
import joserodpt.realscoreboard.api.conditions.ConditionManager;
import joserodpt.realscoreboard.api.managers.AnimationManagerAPI;
import joserodpt.realscoreboard.api.managers.DatabaseManagerAPI;
import joserodpt.realscoreboard.api.managers.PlayerManagerAPI;
import joserodpt.realscoreboard.api.managers.ScoreboardManagerAPI;
import joserodpt.realscoreboard.api.utils.IPlaceholders;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class RealScoreboardAPI {
    private static RealScoreboardAPI instance;

    public static void setInstance(RealScoreboardAPI instance) {
        Preconditions.checkNotNull((Object)instance, (Object)"instance");
        Preconditions.checkArgument((RealScoreboardAPI.instance == null ? 1 : 0) != 0, (Object)"Instance already set");
        RealScoreboardAPI.instance = instance;
    }

    public abstract ScoreboardManagerAPI getScoreboardManagerAPI();

    public abstract DatabaseManagerAPI getDatabaseManagerAPI();

    public abstract PlayerManagerAPI getPlayerManagerAPI();

    public abstract AnimationManagerAPI getAnimationManagerAPI();

    public abstract Logger getLogger();

    public abstract IPlaceholders getPlaceholders();

    public abstract JavaPlugin getPlugin();

    public abstract void reload();

    public String getVersion() {
        return this.getPlugin().getDescription().getVersion();
    }

    public abstract ConditionManager getConditionManager();

    public static RealScoreboardAPI getInstance() {
        return instance;
    }
}

