/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.conditions;

import joserodpt.realscoreboard.api.RealScoreboardAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Condition {
    private String condition;
    private String met;
    private String notMet;
    private RealScoreboardAPI rsa;

    public Condition(RealScoreboardAPI rsa, String condition, String met, String notMet) {
        this.rsa = rsa;
        this.condition = condition;
        this.met = met;
        this.notMet = notMet;
    }

    public boolean parseExpression(String expression) {
        String[] tokens = expression.trim().split("\\s+");
        if (tokens.length != 3) {
            throw new IllegalArgumentException("Invalid expression format. Expected format: 'operand operator operand'");
        }
        String leftOperand = tokens[0];
        String operator = tokens[1];
        String rightOperand = tokens[2];
        Object left = this.parseValue(leftOperand);
        Object right = this.parseValue(rightOperand);
        return this.evaluate(left, operator, right);
    }

    private Object parseValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException2) {
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                    return Boolean.parseBoolean(value);
                }
                return value;
            }
        }
    }

    private boolean evaluate(Object left, String operator, Object right) {
        if (left instanceof Number && right instanceof Number) {
            return this.evaluateNumbers((Number)left, operator, (Number)right);
        }
        if (left instanceof String && right instanceof String) {
            return this.evaluateStrings((String)left, operator, (String)right);
        }
        return switch (operator) {
            case "==" -> left.equals(right);
            case "!=" -> {
                if (!left.equals(right)) {
                    yield true;
                }
                yield false;
            }
            default -> throw new UnsupportedOperationException("Unsupported operator: " + operator);
        };
    }

    private boolean evaluateNumbers(Number left, String operator, Number right) {
        double leftDouble = left.doubleValue();
        double rightDouble = right.doubleValue();
        return switch (operator) {
            case "==" -> {
                if (leftDouble == rightDouble) {
                    yield true;
                }
                yield false;
            }
            case "!=" -> {
                if (leftDouble != rightDouble) {
                    yield true;
                }
                yield false;
            }
            case ">" -> {
                if (leftDouble > rightDouble) {
                    yield true;
                }
                yield false;
            }
            case "<" -> {
                if (leftDouble < rightDouble) {
                    yield true;
                }
                yield false;
            }
            case ">=" -> {
                if (leftDouble >= rightDouble) {
                    yield true;
                }
                yield false;
            }
            case "<=" -> {
                if (leftDouble <= rightDouble) {
                    yield true;
                }
                yield false;
            }
            default -> throw new UnsupportedOperationException("Unsupported operator for numeric comparison: " + operator);
        };
    }

    private boolean evaluateStrings(String left, String operator, String right) {
        return switch (operator) {
            case "==" -> left.equals(right);
            case "!=" -> {
                if (!left.equals(right)) {
                    yield true;
                }
                yield false;
            }
            case "contains" -> left.contains(right);
            case "startsWith" -> left.startsWith(right);
            case "endsWith" -> left.endsWith(right);
            default -> throw new UnsupportedOperationException("Unsupported operator for string comparison: " + operator);
        };
    }

    public String evaluate(Player player) {
        try {
            String evaluatedCondition = this.rsa.getPlaceholders().setPlaceholders(player, this.condition, true);
            boolean conditionMet = this.parseExpression(evaluatedCondition);
            String result = conditionMet ? this.getMet() : this.getNotMet();
            return this.rsa.getPlaceholders().setPlaceholders(player, result, false);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Error parsing condition: " + this.condition + " for player: " + player.getName());
            e.printStackTrace();
            return "Error parsing. See console";
        }
    }

    public String getCondition() {
        return this.condition;
    }

    public String getMet() {
        return this.met;
    }

    public String getNotMet() {
        return this.notMet;
    }

    public RealScoreboardAPI getRsa() {
        return this.rsa;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setMet(String met) {
        this.met = met;
    }

    public void setNotMet(String notMet) {
        this.notMet = notMet;
    }

    public void setRsa(RealScoreboardAPI rsa) {
        this.rsa = rsa;
    }
}

