/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.conditions;

import java.util.HashMap;
import java.util.Map;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.conditions.Condition;
import joserodpt.realscoreboard.api.config.RSBConfig;

public class ConditionManager {
    private final RealScoreboardAPI rsa;
    private final Map<String, Condition> conditions = new HashMap<String, Condition>();

    public ConditionManager(RealScoreboardAPI rsa) {
        this.rsa = rsa;
        this.loadConditions();
    }

    public void loadConditions() {
        this.conditions.clear();
        for (String key : RSBConfig.file().getSection("Config.Conditions").getRoutesAsStrings(false)) {
            String conditionString = RSBConfig.file().getString("Config.Conditions." + key + ".Condition");
            String met = RSBConfig.file().getString("Config.Conditions." + key + ".Met");
            String notMet = RSBConfig.file().getString("Config.Conditions." + key + ".Not-Met");
            this.conditions.put(key, new Condition(this.rsa, conditionString, met, notMet));
        }
        if (!this.conditions.isEmpty()) {
            this.rsa.getLogger().info("Loaded " + this.conditions.size() + " conditions.");
        }
    }

    public Condition getCondition(String name) {
        return this.conditions.get(name);
    }
}

