/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.scoreboard;

import java.util.List;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.scoreboard.RScoreboard;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RBoard {
    protected int titleIndex;
    protected BukkitTask titleLooperTask;
    private final List<String> title;
    private final List<String> lines;
    private RScoreboard rsb;

    public RBoard(List<String> title, List<String> lines) {
        this.title = title;
        this.lines = lines;
    }

    public RBoard(RScoreboard rsb, List<String> title, List<String> lines) {
        this(title, lines);
        this.rsb = rsb;
    }

    public List<String> getTitleList() {
        return this.title;
    }

    public String getTitle() {
        return this.getTitleList().get(this.titleIndex);
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void stopTasks() {
        if (this.titleLooperTask != null) {
            this.titleLooperTask.cancel();
        }
    }

    public void init() {
        if (this.rsb == null) {
            RealScoreboardAPI.getInstance().getLogger().severe("RBoard with title: " + this.getTitleList().toString() + " doesn't have a Scoreboard assigned in code! (possible bug)");
            return;
        }
        this.titleIndex = 0;
        if (this.title.size() > 1) {
            this.titleLooperTask = new BukkitRunnable(){

                public void run() {
                    RBoard.this.titleIndex = RBoard.this.titleIndex == RBoard.this.title.size() - 1 ? 0 : ++RBoard.this.titleIndex;
                }
            }.runTaskTimerAsynchronously((Plugin)RealScoreboardAPI.getInstance().getPlugin(), 0L, (long)this.rsb.titleLoopDelay);
        }
    }

    public void setScoreboard(RScoreboard rsb) {
        this.rsb = rsb;
    }
}

