/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.scoreboard;

import fr.mrmicky.fastboard.FastBoard;
import java.util.Collection;
import java.util.stream.Collectors;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.config.PlayerData;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.scoreboard.RScoreboard;
import joserodpt.realscoreboard.api.scoreboard.RScoreboardSingle;
import joserodpt.realscoreboard.api.utils.Text;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RSBPlayer {
    private final Player p;
    private RScoreboard current;
    private FastBoard fastBoard;
    private BukkitTask scoreboardRefreshTask;
    private boolean realScoreboardVisible;

    public RSBPlayer(Player p) {
        this.p = p;
        this.realScoreboardVisible = !RSBConfig.file().getStringList("Config.Disabled-Worlds").contains(p.getWorld().getName()) && !RSBConfig.file().getStringList("Config.Bypass-Worlds").contains(p.getWorld().getName()) && RealScoreboardAPI.getInstance().getDatabaseManagerAPI().getPlayerData(p.getUniqueId()).isScoreboardON();
        this.setScoreboard(RealScoreboardAPI.getInstance().getScoreboardManagerAPI().getScoreboardForPlayer(p));
        if (this.realScoreboardVisible) {
            this.startScoreboard();
        }
    }

    public void startScoreboard() {
        if (this.current != null) {
            this.realScoreboardVisible = true;
            this.fastBoard = new FastBoard(this.p);
            this.scoreboardRefreshTask = new BukkitRunnable(){

                public void run() {
                    if (!RSBPlayer.this.p.isOnline() || !RSBPlayer.this.realScoreboardVisible) {
                        this.cancel();
                        return;
                    }
                    if (RSBPlayer.this.current != null) {
                        String title = RSBPlayer.this.current.getTitle();
                        if (RSBConfig.file().getBoolean("Config.Use-Placeholders-In-Scoreboard-Titles").booleanValue()) {
                            title = RealScoreboardAPI.getInstance().getPlaceholders().setPlaceholders(RSBPlayer.this.p, title, false);
                        }
                        if (RSBPlayer.this.fastBoard != null && !RSBPlayer.this.fastBoard.isDeleted()) {
                            RSBPlayer.this.fastBoard.updateTitle(Text.color(title));
                        }
                        Collection list = RSBPlayer.this.current.getLines().stream().map(s -> RealScoreboardAPI.getInstance().getPlaceholders().setPlaceholders(RSBPlayer.this.p, (String)s, false)).filter(s -> !s.contains("$skip")).map(s -> {
                            s = s.matches("(?i)%blank%") ? Text.randomColor() + "\u00a7r" + Text.randomColor() : s;
                            return Text.color(s);
                        }).collect(Collectors.toList());
                        if (RSBPlayer.this.fastBoard != null && !RSBPlayer.this.fastBoard.isDeleted() && !list.isEmpty()) {
                            RSBPlayer.this.fastBoard.updateLines(list);
                        }
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)RealScoreboardAPI.getInstance().getPlugin(), 0L, (long)this.current.globalScoreboardRefresh);
        }
    }

    public void stopScoreboard() {
        if (this.scoreboardRefreshTask != null) {
            this.scoreboardRefreshTask.cancel();
        }
        if (this.fastBoard != null && !this.fastBoard.isDeleted()) {
            this.fastBoard.delete();
            this.fastBoard = null;
        }
        this.realScoreboardVisible = false;
    }

    public void setScoreboard(RScoreboard sb) {
        if (RSBConfig.file().getStringList("Config.Disabled-Worlds").contains(this.p.getWorld().getName())) {
            this.stopScoreboard();
            return;
        }
        if (sb != null) {
            this.current = sb;
            if (!this.isScoreboardActive() && this.isRealScoreboardVisible()) {
                this.startScoreboard();
            }
        } else {
            this.stopScoreboard();
        }
    }

    public boolean isScoreboardActive() {
        return this.scoreboardRefreshTask != null && this.fastBoard != null && !this.fastBoard.isDeleted();
    }

    public void setRealScoreboardVisible(boolean realScoreboardVisible) {
        if (realScoreboardVisible != this.realScoreboardVisible) {
            if (realScoreboardVisible) {
                this.startScoreboard();
            } else {
                this.stopScoreboard();
            }
        }
        this.realScoreboardVisible = realScoreboardVisible;
        PlayerData playerData = RealScoreboardAPI.getInstance().getDatabaseManagerAPI().getPlayerData(this.p.getUniqueId());
        playerData.setScoreboardON(this.realScoreboardVisible);
        RealScoreboardAPI.getInstance().getDatabaseManagerAPI().savePlayerData(playerData, true);
    }

    public RScoreboard getScoreboard() {
        return this.current;
    }

    public Player getPlayer() {
        return this.p;
    }

    public String toString() {
        return "RSBPlayer{player=" + String.valueOf(this.p) + ", current=" + String.valueOf(this.current) + ", fastBoard=" + String.valueOf(this.fastBoard) + ", scoreboardRefreshTask=" + String.valueOf(this.scoreboardRefreshTask) + "}";
    }

    public void announce(String message, Integer seconds) {
        RScoreboard prev = this.current;
        this.setScoreboard(new RScoreboardSingle(message));
        Bukkit.getScheduler().runTaskLater((Plugin)RealScoreboardAPI.getInstance().getPlugin(), () -> this.setScoreboard(prev), (long)((seconds == null ? 10 : seconds) * 20));
    }

    public boolean isRealScoreboardVisible() {
        return this.realScoreboardVisible;
    }
}

