/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.scoreboard;

import java.util.Collections;
import java.util.List;
import joserodpt.realscoreboard.api.config.RSBScoreboards;
import org.bukkit.World;

public abstract class RScoreboard {
    protected final String name;
    protected final String displayName;
    protected String permission;
    protected final String defaultWorld;
    protected final List<String> otherWorlds;
    protected final int titleRefresh;
    protected final int titleLoopDelay;
    protected final int globalScoreboardRefresh;
    protected boolean defaultScoreboard;

    public RScoreboard(String name, String displayName, String permission, String defaultWorld, List<String> otherWorlds, int titleRefresh, int titleLoopDelay, int globalScoreboardRefresh, boolean defaultScoreboard) {
        this.name = name;
        this.defaultScoreboard = defaultScoreboard;
        this.displayName = displayName;
        this.permission = permission;
        this.defaultWorld = defaultWorld;
        this.otherWorlds = otherWorlds;
        this.titleRefresh = titleRefresh;
        this.titleLoopDelay = titleLoopDelay;
        this.globalScoreboardRefresh = globalScoreboardRefresh;
    }

    public abstract void stopTasks();

    public abstract void init();

    public abstract String getTitle();

    public abstract List<String> getLines();

    public abstract void saveScoreboard();

    public String getConfigKey() {
        return "Scoreboards." + this.getName() + ".";
    }

    public void saveCommonData() {
        RSBScoreboards.file().set(this.getConfigKey() + "Default", (Object)this.isDefault());
        RSBScoreboards.file().set(this.getConfigKey() + "Default-World", (Object)this.getDefaultWord());
        RSBScoreboards.file().set(this.getConfigKey() + "Other-Worlds", Collections.emptyList());
        RSBScoreboards.file().set(this.getConfigKey() + "Display-Name", (Object)this.getDisplayName());
        RSBScoreboards.file().set(this.getConfigKey() + "Permission", (Object)this.getPermission());
        RSBScoreboards.file().set(this.getConfigKey() + "Refresh.Scoreboard", (Object)this.globalScoreboardRefresh);
        RSBScoreboards.file().set(this.getConfigKey() + "Refresh.Title", (Object)this.titleRefresh);
        RSBScoreboards.file().set(this.getConfigKey() + "Refresh.Title-Loop-Delay", (Object)this.titleLoopDelay);
    }

    public boolean isDefault() {
        return this.defaultScoreboard;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setPermission(String none) {
        this.permission = none;
    }

    public String getPermission() {
        return this.permission;
    }

    public String getDefaultWord() {
        return this.defaultWorld;
    }

    public void setDefault(boolean b) {
        this.defaultScoreboard = b;
    }

    public boolean isInWorld(World world) {
        if (this.otherWorlds.size() == 1 && this.otherWorlds.get(0).equalsIgnoreCase("*")) {
            return true;
        }
        return this.getDefaultWord().equalsIgnoreCase(world.getName()) || this.otherWorlds.contains(world.getName());
    }

    public String toString() {
        return "RScoreboard{name='" + this.name + "', displayName='" + this.displayName + "', permission='" + this.permission + "', defaultWorld='" + this.defaultWorld + "', otherWorlds=" + String.valueOf(this.otherWorlds) + ", titleRefresh=" + this.titleRefresh + ", titleLoopDelay=" + this.titleLoopDelay + ", globalScoreboardRefresh=" + this.globalScoreboardRefresh + ", defaultScoreboard=" + this.defaultScoreboard + "}";
    }
}

