/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.scoreboard;

import java.util.ArrayList;
import java.util.List;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.config.RSBScoreboards;
import joserodpt.realscoreboard.api.scoreboard.RBoard;
import joserodpt.realscoreboard.api.scoreboard.RScoreboard;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class RScoreboardBoards
extends RScoreboard {
    protected List<RBoard> boards = new ArrayList<RBoard>();
    protected final int boardLoopDelay;
    protected int boardIndex = 0;
    private BukkitTask boardsLooperTask;

    public RScoreboardBoards(String name, String displayName, String permission, String defaultWord, List<String> otherWorlds, int titleRefresh, int titleLoopDelay, int globalScoreboardRefresh, int boardLoopDelay, boolean defaultSB) {
        super(name, displayName, permission, defaultWord, otherWorlds, titleRefresh, titleLoopDelay, globalScoreboardRefresh, defaultSB);
        this.boardLoopDelay = boardLoopDelay;
        for (String boardNames : RSBScoreboards.file().getSection("Scoreboards." + name + ".Boards").getRoutesAsStrings(false)) {
            this.boards.add(new RBoard(this, RSBScoreboards.file().getStringList("Scoreboards." + name + ".Boards." + boardNames + ".Title"), RSBScoreboards.file().getStringList("Scoreboards." + name + ".Boards." + boardNames + ".Lines")));
        }
    }

    public RScoreboardBoards(String name, String permission, String defaultWord, List<String> otherWorlds, int titleRefresh, int titleLoopDelay, int globalScoreboardRefresh, int boardLoopDelay, boolean defaultSB) {
        super(name, "&7" + name, permission, defaultWord, otherWorlds, titleRefresh, titleLoopDelay, globalScoreboardRefresh, defaultSB);
        this.boardLoopDelay = boardLoopDelay;
    }

    @Override
    public void stopTasks() {
        this.boards.forEach(RBoard::stopTasks);
        if (this.boardsLooperTask != null) {
            this.boardsLooperTask.cancel();
        }
    }

    @Override
    public void init() {
        this.boards.forEach(RBoard::init);
        if (this.boards.size() > 1) {
            this.boardsLooperTask = new BukkitRunnable(){

                public void run() {
                    RScoreboardBoards.this.boardIndex = RScoreboardBoards.this.boardIndex >= RScoreboardBoards.this.boards.size() - 1 ? 0 : ++RScoreboardBoards.this.boardIndex;
                }
            }.runTaskTimerAsynchronously((Plugin)RealScoreboardAPI.getInstance().getPlugin(), 0L, (long)this.boardLoopDelay);
        }
    }

    public RBoard getCurrentBoard() {
        return this.boards.get(this.boardIndex);
    }

    @Override
    public String getTitle() {
        return this.getCurrentBoard().getTitle();
    }

    @Override
    public List<String> getLines() {
        return this.getCurrentBoard().getLines();
    }

    @Override
    public void saveScoreboard() {
        super.saveCommonData();
        RSBScoreboards.file().set(super.getConfigKey() + "Refresh.Board-Loop-Delay", (Object)this.boardLoopDelay);
        int ctr = 1;
        for (RBoard board : this.boards) {
            RSBScoreboards.file().set(super.getConfigKey() + "Boards.board" + ctr + ".Title", board.getTitleList());
            RSBScoreboards.file().set(super.getConfigKey() + "Boards.board" + ctr + ".Lines", board.getLines());
            ++ctr;
        }
        RSBScoreboards.save();
    }

    public void setBoards(List<RBoard> boards) {
        this.boards = boards;
        this.saveScoreboard();
    }
}

