/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.scoreboard;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.config.RSBScoreboards;
import joserodpt.realscoreboard.api.scoreboard.RBoard;
import joserodpt.realscoreboard.api.scoreboard.RScoreboard;

public class RScoreboardSingle
extends RScoreboard {
    private final RBoard board;

    public RScoreboardSingle(String name, String permission, String defaultWord, List<String> otherWorlds, List<String> title, List<String> lines, int titleRefresh, int titleLoopDelay, int globalScoreboardRefresh, boolean defaultSB, boolean save) {
        super(name, "&7" + name, permission, defaultWord, otherWorlds, titleRefresh, titleLoopDelay, globalScoreboardRefresh, defaultSB);
        this.board = new RBoard(this, title, lines);
        if (save) {
            this.saveScoreboard();
        }
    }

    public RScoreboardSingle(String name, String displayName, String permission, String defaultWord, List<String> otherWorlds, List<String> title, List<String> lines, int titleRefresh, int titleLoopDelay, int globalScoreboardRefresh, boolean defaultSB) {
        super(name, displayName, permission, defaultWord, otherWorlds, titleRefresh, titleLoopDelay, globalScoreboardRefresh, defaultSB);
        this.board = new RBoard(this, title, lines);
    }

    public RScoreboardSingle(String message) {
        super("", "", "", "", Collections.emptyList(), 40, 20, 20, false);
        this.board = new RBoard(this, Collections.singletonList(RSBConfig.file().getString("Config.Messages.Announce-Title")), Arrays.stream(message.split("(?<=\\G.{30})")).collect(Collectors.toList()));
    }

    @Override
    public void stopTasks() {
        this.board.stopTasks();
    }

    @Override
    public void init() {
        this.board.init();
    }

    @Override
    public String getTitle() {
        return this.board.getTitle();
    }

    @Override
    public List<String> getLines() {
        return this.board.getLines();
    }

    @Override
    public void saveScoreboard() {
        super.saveCommonData();
        RSBScoreboards.file().set(super.getConfigKey() + "Title", this.board.getTitleList());
        RSBScoreboards.file().set(super.getConfigKey() + "Lines", this.getLines());
        RSBScoreboards.save();
    }
}

