/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Pagination<T>
extends ArrayList<T> {
    private int pageSize;

    public Pagination(int pageSize) {
        this(pageSize, new ArrayList());
    }

    @SafeVarargs
    public Pagination(int pageSize, T ... objects) {
        this(pageSize, Arrays.asList(objects));
    }

    public Pagination(int pageSize, List<T> objects) {
        this.pageSize = pageSize;
        this.addAll(objects);
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int totalPages() {
        return (int)Math.ceil((double)this.size() / (double)this.pageSize);
    }

    public boolean exists(int page) {
        return page >= 0 && page < this.totalPages();
    }

    public List<T> getPage(int page) {
        if (page < 0 || page >= this.totalPages()) {
            throw new IndexOutOfBoundsException("Page: " + page + ", Size: " + this.totalPages());
        }
        ArrayList objects = new ArrayList();
        int min = page * this.pageSize;
        int max = page * this.pageSize + this.pageSize;
        if (max > this.size()) {
            max = this.size();
        }
        for (int i = min; max > i; ++i) {
            objects.add(this.get(i));
        }
        return objects;
    }
}

