/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PingUtil {
    private static final int pingVersion;
    private static String nmsVersion;
    private static Method getHandleMethod;
    private static Method getPingMethod;
    private static Field pingField;

    public static int getPing(Player p) {
        return switch (pingVersion) {
            case 1 -> PingUtil.getNewPing(p);
            case 0 -> PingUtil.getPingReflection(p);
            default -> -3;
        };
    }

    public static int getNewPing(Player p) {
        try {
            return p.getPing();
        }
        catch (Exception e) {
            return -2;
        }
    }

    public static int getPingReflection(Player p) {
        try {
            if (getHandleMethod == null) {
                getHandleMethod = p.getClass().getDeclaredMethod("getHandle", new Class[0]);
                getHandleMethod.setAccessible(true);
            }
            Object entityPlayer = getHandleMethod.invoke((Object)p, new Object[0]);
            if (pingField == null && getPingMethod == null) {
                try {
                    pingField = entityPlayer.getClass().getDeclaredField("ping");
                }
                catch (NoSuchFieldError | NoSuchFieldException e) {
                    getPingMethod = Class.forName("org.bukkit.craftbukkit." + PingUtil.getNmsVersion() + ".entity.CraftPlayer").getDeclaredMethod("getPing", new Class[0]);
                }
                if (pingField != null) {
                    pingField.setAccessible(true);
                }
            }
            int ping = getPingMethod != null ? ((Integer)getPingMethod.invoke((Object)p, new Object[0])).intValue() : pingField.getInt(entityPlayer);
            return Math.max(ping, 0);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static String getNmsVersion() {
        if (nmsVersion == null) {
            nmsVersion = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
        }
        return nmsVersion;
    }

    static {
        String version;
        switch (version = Bukkit.getServer().getBukkitVersion().split("-")[0]) {
            case "1.16.5": 
            case "1.16.4": 
            case "1.16.3": 
            case "1.16.2": 
            case "1.16.1": 
            case "1.16": 
            case "1.15.2": 
            case "1.15.1": 
            case "1.15": 
            case "1.14.4": 
            case "1.14.3": 
            case "1.14.2": 
            case "1.14.1": 
            case "1.14": 
            case "1.13.2": 
            case "1.13.1": 
            case "1.13": {
                Bukkit.getLogger().info("[RealScoreboard] Using 1.13-1.16.5 ping method.");
                pingVersion = 0;
                break;
            }
            default: {
                Bukkit.getLogger().info("[RealScoreboard] Using 1.17+ ping method.");
                pingVersion = 1;
            }
        }
    }
}

