/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.utils.Text;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PlayerInput
implements Listener {
    private static final Map<UUID, PlayerInput> inputs = new HashMap<UUID, PlayerInput>();
    private final UUID uuid;
    private final List<String> texts = Text.color(Arrays.asList("&l&9Type in chat your input", "&fType &4cancel &fto cancel"));
    private final InputRunnable runGo;
    private final InputRunnable runCancel;
    private final BukkitTask taskId;
    private final Boolean inputMode;

    public PlayerInput(final Player p, InputRunnable correct, InputRunnable cancel) {
        this.uuid = p.getUniqueId();
        p.closeInventory();
        this.inputMode = true;
        this.runGo = correct;
        this.runCancel = cancel;
        this.taskId = new BukkitRunnable(){

            public void run() {
                p.sendTitle(PlayerInput.this.texts.get(0), PlayerInput.this.texts.get(1), 0, 21, 0);
            }
        }.runTaskTimer((Plugin)RealScoreboardAPI.getInstance().getPlugin(), 0L, 20L);
        this.register();
    }

    private void register() {
        inputs.put(this.uuid, this);
    }

    private void unregister() {
        inputs.remove(this.uuid);
    }

    public static Listener getListener() {
        return new Listener(){

            @EventHandler
            public void onPlayerChat(AsyncPlayerChatEvent event) {
                Player p = event.getPlayer();
                String input = event.getMessage();
                UUID uuid = p.getUniqueId();
                if (inputs.containsKey(uuid)) {
                    PlayerInput current = inputs.get(uuid);
                    if (current.inputMode.booleanValue()) {
                        event.setCancelled(true);
                        try {
                            if (input.equalsIgnoreCase("cancel")) {
                                Text.send(p, "&cInput cancelled.");
                                current.taskId.cancel();
                                p.sendTitle("", "", 0, 1, 0);
                                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RealScoreboardAPI.getInstance().getPlugin(), () -> current.runCancel.run(input), 3L);
                                current.unregister();
                                return;
                            }
                            current.taskId.cancel();
                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RealScoreboardAPI.getInstance().getPlugin(), () -> current.runGo.run(input), 3L);
                            p.sendTitle("", "", 0, 1, 0);
                            current.unregister();
                        }
                        catch (Exception e) {
                            Text.send(p, "&cAn error ocourred. Contact JoseGamer_PT on SpigotMC.com");
                            RealScoreboardAPI.getInstance().getLogger().severe(e.getMessage());
                        }
                    }
                }
            }
        };
    }

    @FunctionalInterface
    public static interface InputRunnable {
        public void run(String var1);
    }
}

