/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.api.utils;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.utils.ForestColorAPI;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Text {
    static final String[] time = new String[]{"s", "m", "h", "h", "h", "h", "h", "h", "h"};
    static String[] money = new String[]{"", "k", "m", "b", "t", "q", "qi", "s", "sep", "OC", "N", "DEC", "UN", "DUO", "TRE"};

    public static String color(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        return ForestColorAPI.colorize(text);
    }

    public static List<String> color(List<?> list) {
        ArrayList<String> color = new ArrayList<String>();
        list.forEach(o -> color.add(Text.color((String)o)));
        return color;
    }

    public static String formatMoney(double value) {
        int index = 0;
        while (value / 1000.0 >= 1.0) {
            value /= 1000.0;
            ++index;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return String.format("%s%s", decimalFormat.format(value), money[index]);
    }

    public static String formatTime(int value) {
        int index = 0;
        while (value / 1000 >= 1) {
            value /= 1000;
            ++index;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return String.format("%s%s", decimalFormat.format(value), time[index]);
    }

    public static String getPrefix() {
        return Text.color(RSBConfig.file().getString("Config.Prefix"));
    }

    public static String randomColor() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(RealScoreboardAPI.getInstance().getAnimationManagerAPI().getLoopAnimation("rainbow") + "&6"));
    }

    public static void send(CommandSender commandSender, List<String> asList) {
        asList.forEach(s -> commandSender.sendMessage(Text.color(s)));
    }

    public static void send(Player commandSender, String msg) {
        commandSender.sendMessage(Text.getPrefix() + Text.color(msg));
    }

    public static void send(CommandSender commandSender, String msg) {
        commandSender.sendMessage(Text.getPrefix() + Text.color(msg));
    }

    public static String formatMoneyLong(double money) {
        NumberFormat nf = DecimalFormat.getInstance(Locale.ENGLISH);
        DecimalFormat decimalFormatter = (DecimalFormat)nf;
        decimalFormatter.applyPattern("#,###,###.##");
        return decimalFormatter.format(money);
    }
}

