/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.commands;

import dev.triumphteam.cmd.bukkit.annotation.Permission;
import dev.triumphteam.cmd.core.annotation.Command;
import dev.triumphteam.cmd.core.annotation.Default;
import dev.triumphteam.cmd.core.annotation.SubCommand;
import dev.triumphteam.cmd.core.annotation.Suggestion;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.scoreboard.RSBPlayer;
import joserodpt.realscoreboard.api.scoreboard.RScoreboard;
import joserodpt.realscoreboard.api.utils.GUIBuilder;
import joserodpt.realscoreboard.api.utils.Items;
import joserodpt.realscoreboard.api.utils.Text;
import joserodpt.realscoreboard.commands.BaseCommandWA;
import joserodpt.realscoreboard.commands.WrongUsage;
import joserodpt.realscoreboard.gui.SettingsGUI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(value="realscoreboard", alias={"rsb", "sb"})
public class RealScoreboardCommand
extends BaseCommandWA {
    private final String playerOnly = "Only players can use this command.";
    private final RealScoreboardAPI rsa;

    public RealScoreboardCommand(RealScoreboardAPI rsa) {
        this.rsa = rsa;
    }

    @Default
    public void defaultcmd(CommandSender commandSender) {
        Player p;
        if (commandSender instanceof Player && ((p = (Player)commandSender).isOp() || p.hasPermission("realscoreboard.admin"))) {
            SettingsGUI s = new SettingsGUI(p, this.rsa);
            s.openInventory(p);
        } else {
            commandSender.sendMessage(Text.color("&fReal&dScoreboard &7| &fv" + this.rsa.getVersion()));
        }
    }

    @SubCommand(value="reload")
    @Permission(value={"realscoreboard.admin"})
    public void reloadcmd(CommandSender commandSender) {
        this.rsa.reload();
        commandSender.sendMessage(Text.color("&fReal&dScoreboard &7| &f" + RSBConfig.file().getString("Config.Reloaded")));
    }

    @SubCommand(value="toggle", alias={"t"})
    @Permission(value={"realscoreboard.toggle"})
    public void togglecmd(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            RSBPlayer hook;
            Player p = (Player)commandSender;
            hook.setRealScoreboardVisible(!(hook = this.rsa.getPlayerManagerAPI().getPlayer(p.getUniqueId())).isRealScoreboardVisible());
            Text.send(p, RSBConfig.file().getString("Config.Messages.Scoreboard-Toggle." + (hook.isRealScoreboardVisible() ? "ON" : "OFF")));
        } else {
            Text.send(commandSender, "Only players can use this command.");
        }
    }

    @SubCommand(value="toggleo", alias={"to", "toggleother"})
    @Permission(value={"realscoreboard.admin"})
    @WrongUsage(value="&cUsage: /rsb toggleother <player>")
    public void toggleothercmd(CommandSender commandSender, Player player) {
        RSBPlayer hook;
        if (player == null) {
            Text.send(commandSender, "Player not found.");
            return;
        }
        hook.setRealScoreboardVisible(!(hook = this.rsa.getPlayerManagerAPI().getPlayer(player.getUniqueId())).isRealScoreboardVisible());
        Text.send(commandSender, RSBConfig.file().getString("Config.Messages.Scoreboard-Toggle." + (hook.isRealScoreboardVisible() ? "ON" : "OFF")));
    }

    @SubCommand(value="off")
    @Permission(value={"realscoreboard.toggle"})
    public void offcmd(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            Player p = (Player)commandSender;
            RSBPlayer hook = this.rsa.getPlayerManagerAPI().getPlayer(p.getUniqueId());
            hook.setRealScoreboardVisible(false);
            Text.send(p, RSBConfig.file().getString("Config.Messages.Scoreboard-Toggle.OFF"));
        } else {
            Text.send(commandSender, "Only players can use this command.");
        }
    }

    @SubCommand(value="on")
    @Permission(value={"realscoreboard.toggle"})
    public void oncmd(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            Player p = (Player)commandSender;
            RSBPlayer hook = this.rsa.getPlayerManagerAPI().getPlayer(p.getUniqueId());
            hook.setRealScoreboardVisible(true);
            Text.send(p, RSBConfig.file().getString("Config.Messages.Scoreboard-Toggle.ON"));
        } else {
            Text.send(commandSender, "Only players can use this command.");
        }
    }

    @SubCommand(value="selectscoreboard", alias={"selectsb"})
    @Permission(value={"realscoreboard.selectscoreboard"})
    @WrongUsage(value="&cUsage: /rsb selectscoreboard <player>")
    public void selectscoreboardcmd(CommandSender commandSender, Player target) {
        if (commandSender instanceof Player) {
            Player p = (Player)commandSender;
            if (target == null) {
                Text.send(commandSender, "Player not found.");
                return;
            }
            GUIBuilder inventory = new GUIBuilder("Choose board for " + target.getName(), 27, target.getUniqueId());
            Collection<RScoreboard> list = this.rsa.getScoreboardManagerAPI().getScoreboards();
            int i = 0;
            for (RScoreboard sb : list) {
                inventory.addItem(e -> {
                    target.closeInventory();
                    this.rsa.getPlayerManagerAPI().getPlayer(target.getUniqueId()).setScoreboard(sb);
                    Text.send(p, "Scoreboard &b" + sb.getName() + " &fapplied to &b" + target.getName());
                }, Items.createItemLore(Material.FILLED_MAP, 1, sb.getDisplayName(), Collections.singletonList("&7Click to apply.")), i);
                ++i;
            }
            inventory.openInventory(target);
        } else {
            Text.send(commandSender, "Only players can use this command.");
        }
    }

    @SubCommand(value="setscoreboard", alias={"setsb"})
    @Permission(value={"realscoreboard.setscoreboard"})
    @WrongUsage(value="&cUsage: /rsb setscoreboard <name> <player>")
    public void setscoreboardcmd(CommandSender commandSender, @Suggestion(value="#scoreboards") String name, Player target) {
        RScoreboard sb = this.rsa.getScoreboardManagerAPI().getScoreboard(name);
        if (sb == null) {
            Text.send(commandSender, "Scoreboard not found with that name.");
            return;
        }
        if (target == null) {
            Text.send(commandSender, "Player not found.");
            return;
        }
        if (this.rsa.getPlayerManagerAPI().getPlayer(target.getUniqueId()).getScoreboard() == sb) {
            Text.send(commandSender, target.getName() + " &calready has that scoreboard applied.");
        } else {
            this.rsa.getPlayerManagerAPI().getPlayer(target.getUniqueId()).setScoreboard(sb);
            Text.send(commandSender, name + " scoreboard applied to " + target.getName());
        }
    }

    @SubCommand(value="setscoreboardall", alias={"setsball"})
    @Permission(value={"realscoreboard.setscoreboard"})
    @WrongUsage(value="&cUsage: /rsb setsball <name>")
    public void setscoreboardallcmd(CommandSender commandSender, @Suggestion(value="#scoreboards") String name) {
        RScoreboard sb = this.rsa.getScoreboardManagerAPI().getScoreboard(name);
        if (sb == null) {
            Text.send(commandSender, "Scoreboard not found with that name.");
            return;
        }
        Bukkit.getOnlinePlayers().forEach(target -> {
            if (this.rsa.getPlayerManagerAPI().getPlayer(target.getUniqueId()).getScoreboard() != sb) {
                this.rsa.getPlayerManagerAPI().getPlayer(target.getUniqueId()).setScoreboard(sb);
            }
        });
        Text.send(commandSender, name + " scoreboard applied to all players. ");
    }

    @SubCommand(value="announce", alias={"broadcast"})
    @Permission(value={"realscoreboard.setscoreboard"})
    @WrongUsage(value="&cUsage: /rsb announce <seconds> <message>")
    public void announcecmd(CommandSender commandSender, Integer seconds, List<String> args) {
        if (args.isEmpty()) {
            Text.send(commandSender, "&cUsage: /rsb announce <seconds> <message>");
            return;
        }
        String message = String.join((CharSequence)" ", args);
        this.rsa.getPlayerManagerAPI().getPlayerMap().values().forEach(rsbPlayer -> rsbPlayer.announce(message, seconds));
        Text.send(commandSender, "Announcement sent to all players.");
        Text.send(commandSender, "Message: " + message);
    }

    @SubCommand(value="debug")
    @Permission(value={"realscoreboard.admin"})
    public void debugcmd(CommandSender commandSender) {
        Text.send(commandSender, Arrays.asList("", "", Text.getPrefix(), "> &b&lPLUGIN info", "&fPlugin Version: &b" + this.rsa.getVersion(), "> &b&lSERVER info", "&fServer Name: &b" + Bukkit.getName(), "&fServer Version: &b" + Bukkit.getVersion(), "> &b&lHOST info", "&fJava Version: &b" + System.getProperty("java.version"), "&fOS Name: &b" + System.getProperty("os.name"), "&fOS Architecture: &b" + System.getProperty("os.arch"), "&fOS Version: &b" + System.getProperty("os.version"), "> &b&lDATABASE info", "&fDB Driver: &b" + RSBConfig.getSql().getString("driver"), "> &b&lSCOREBOARD info", "&fLoaded Scoreboards: &b" + this.rsa.getScoreboardManagerAPI().getScoreboards().size(), "> &b&lCONFIG info", "&fConfig Version: &b" + RSBConfig.file().getInt("Version"), "&e&lNOTE: &fThis information is intended to be shared with the developer in order to provide additional assistance."));
    }
}

