/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.gui;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.utils.Items;
import joserodpt.realscoreboard.api.utils.Pagination;
import joserodpt.realscoreboard.api.utils.PlayerInput;
import joserodpt.realscoreboard.api.utils.Text;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class SettingsGUI {
    private static final Map<UUID, SettingsGUI> inventories = new HashMap<UUID, SettingsGUI>();
    int pageNumber = 0;
    private Pagination<SettingEntry> p;
    private final ItemStack placeholder = Items.createItem(Material.BLACK_STAINED_GLASS_PANE, 1, "");
    static ItemStack next = Items.createItem(Material.GREEN_STAINED_GLASS, 1, "&aNext");
    static ItemStack back = Items.createItem(Material.YELLOW_STAINED_GLASS, 1, "&6Back");
    static ItemStack close = Items.createItemLore(Material.OAK_DOOR, 1, "&cClose", Collections.singletonList("&7Click here to close the settings."));
    private final Inventory inv;
    private final UUID uuid;
    private final RealScoreboardAPI rsa;
    private final Map<Integer, SettingEntry> display = new HashMap<Integer, SettingEntry>();
    private final ImmutableList<SettingEntry> list = ImmutableList.of((Object)new SettingEntry("Check for Updates", "Config.Check-for-Updates", 0), (Object)new SettingEntry("mcMMO Support", "Config.mcMMO-Support", 0), (Object)new SettingEntry("Use Placeholders In Scoreboard Titles", "Config.Use-Placeholders-In-Scoreboard-Titles", 0), (Object)new SettingEntry("RealScoreboard Disabled By Default", "Config.RealScoreboard-Disabled-By-Default", 0), (Object)new SettingEntry("Auto Hide In Vanish", "Config.Auto-Hide-In-Vanish", 0), (Object)new SettingEntry("Switch Scoreboards Between Worlds", "Config.World-Scoreboard-Switch", 0), (Object)new SettingEntry("Animations Loop Delay", "Config.Animations.Loop-Delay", 1), (Object)new SettingEntry("Hours Offset", "Config.Hours.Offset", 1));

    public SettingsGUI(Player a, RealScoreboardAPI rsa) {
        this.rsa = rsa;
        this.uuid = a.getUniqueId();
        this.inv = Bukkit.getServer().createInventory(null, 54, Text.color("&f&lReal&d&lScoreboard &8| Settings (" + this.list.size() + ")"));
        this.load();
        this.register();
    }

    public void load() {
        this.p = new Pagination<SettingEntry>(28, (List<SettingEntry>)this.list);
        this.fillChest(this.p.getPage(this.pageNumber));
    }

    public static Listener getListener() {
        return new Listener(){

            @EventHandler
            public void onClick(InventoryClickEvent e) {
                HumanEntity clicker = e.getWhoClicked();
                if (clicker instanceof Player) {
                    Player p = (Player)clicker;
                    if (e.getCurrentItem() == null) {
                        return;
                    }
                    UUID uuid = clicker.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        SettingsGUI current = inventories.get(uuid);
                        if (e.getInventory().getHolder() != current.getInventory().getHolder()) {
                            return;
                        }
                        e.setCancelled(true);
                        switch (e.getRawSlot()) {
                            case 49: {
                                p.closeInventory();
                                break;
                            }
                            case 26: 
                            case 35: {
                                if (current.lastPage()) break;
                                this.nextPage(current);
                                p.getPlayer().playSound(p.getPlayer().getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 50.0f, 50.0f);
                                break;
                            }
                            case 18: 
                            case 27: {
                                if (current.firstPage()) break;
                                this.backPage(current);
                                p.getPlayer().playSound(p.getPlayer().getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 50.0f, 50.0f);
                            }
                        }
                        if (current.display.containsKey(e.getRawSlot())) {
                            SettingEntry a = current.display.get(e.getRawSlot());
                            if (a.getEntryType() == 0) {
                                RSBConfig.file().set(a.getConfigPath(), (Object)(RSBConfig.file().getBoolean(a.getConfigPath()) == false ? 1 : 0));
                                RSBConfig.save();
                                current.load();
                            } else {
                                p.closeInventory();
                                new PlayerInput(p, input -> {
                                    int val;
                                    try {
                                        val = Integer.parseInt(input);
                                    }
                                    catch (Exception ignored) {
                                        Text.send(p, "&cNot a valid number without decimal points.");
                                        return;
                                    }
                                    RSBConfig.file().set(a.getConfigPath(), (Object)val);
                                    RSBConfig.save();
                                    Text.send(p, "&fSetting &b" + ChatColor.stripColor((String)a.getName()) + "&f value has been set to &a" + val);
                                    SettingsGUI v = new SettingsGUI(p, current.rsa);
                                    v.openInventory(p);
                                }, input -> {
                                    SettingsGUI v = new SettingsGUI(p, current.rsa);
                                    v.openInventory(p);
                                });
                            }
                        }
                    }
                }
            }

            private void backPage(SettingsGUI asd) {
                if (asd.p.exists(asd.pageNumber - 1)) {
                    --asd.pageNumber;
                }
                asd.fillChest(asd.p.getPage(asd.pageNumber));
            }

            private void nextPage(SettingsGUI asd) {
                if (asd.p.exists(asd.pageNumber + 1)) {
                    ++asd.pageNumber;
                }
                asd.fillChest(asd.p.getPage(asd.pageNumber));
            }

            @EventHandler
            public void onClose(InventoryCloseEvent e) {
                if (e.getPlayer() instanceof Player) {
                    if (e.getInventory() == null) {
                        return;
                    }
                    Player p = (Player)e.getPlayer();
                    UUID uuid = p.getUniqueId();
                    if (inventories.containsKey(uuid)) {
                        inventories.get(uuid).unregister();
                    }
                }
            }
        };
    }

    private boolean lastPage() {
        return this.pageNumber == this.p.totalPages() - 1;
    }

    private boolean firstPage() {
        return this.pageNumber == 0;
    }

    public void openInventory(Player player) {
        Inventory inv = this.getInventory();
        InventoryView openInv = player.getOpenInventory();
        if (openInv != null) {
            Inventory openTop = player.getOpenInventory().getTopInventory();
            if (openTop != null && openTop.getType().name().equalsIgnoreCase(inv.getType().name())) {
                openTop.setContents(inv.getContents());
            } else {
                player.openInventory(inv);
            }
            this.register();
        }
    }

    public void fillChest(List<SettingEntry> items) {
        this.inv.clear();
        this.display.clear();
        for (int slot : new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 36, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53}) {
            this.inv.setItem(slot, this.placeholder);
        }
        if (this.firstPage()) {
            this.inv.setItem(18, this.placeholder);
            this.inv.setItem(27, this.placeholder);
        } else {
            this.inv.setItem(18, back);
            this.inv.setItem(27, back);
        }
        if (this.lastPage()) {
            this.inv.setItem(26, this.placeholder);
            this.inv.setItem(35, this.placeholder);
        } else {
            this.inv.setItem(26, next);
            this.inv.setItem(35, next);
        }
        this.inv.setItem(49, close);
        int slot = 0;
        for (ItemStack i : this.inv.getContents()) {
            if (i == null && !items.isEmpty()) {
                SettingEntry s = items.get(0);
                this.inv.setItem(slot, s.getItem());
                this.display.put(slot, s);
                items.remove(0);
            }
            ++slot;
        }
    }

    public Inventory getInventory() {
        return this.inv;
    }

    private void register() {
        inventories.put(this.uuid, this);
    }

    private void unregister() {
        inventories.remove(this.uuid);
    }

    public static class SettingEntry {
        public int entryType;
        private String configPath;
        private String name;

        public SettingEntry(String name, String configPath, int entryType) {
            this.name = "&f" + name;
            this.configPath = configPath;
            this.entryType = entryType;
        }

        public String getName() {
            return Text.color(this.name);
        }

        public ItemStack getItem() {
            if (this.entryType == 0) {
                boolean val = RSBConfig.file().getBoolean(this.configPath);
                return Items.createItemLore(val ? Material.REDSTONE_TORCH : Material.LEVER, 1, this.getName() + " &f- " + (val ? "&a&lON" : "&c&lOFF"), Collections.singletonList("&7Click here to toggle this setting."));
            }
            return Items.createItemLore(Material.OAK_BUTTON, Math.min(64, Math.max(1, RSBConfig.file().getInt(this.configPath))), this.getName() + ": " + RSBConfig.file().getInt(this.configPath), Collections.singletonList("&7Click here to change this value."));
        }

        public int getEntryType() {
            return this.entryType;
        }

        public String getConfigPath() {
            return this.configPath;
        }
    }
}

