/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.listeners;

import joserodpt.realscoreboard.RealScoreboardPlugin;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.config.PlayerData;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.scoreboard.RSBPlayer;
import joserodpt.realscoreboard.api.utils.Text;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final RealScoreboardAPI rsa;

    public PlayerListener(RealScoreboardAPI rsa) {
        this.rsa = rsa;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void join(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        this.rsa.getPlayerManagerAPI().initPlayer(p);
        if (p.isOp() && RealScoreboardPlugin.getNewUpdate().booleanValue()) {
            Text.send(p, "&6&lWARNING &fThere is a new version of RealScoreboard! https://www.spigotmc.org/resources/22928/");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void leave(PlayerQuitEvent e) {
        RSBPlayer hook = this.rsa.getPlayerManagerAPI().getPlayer(e.getPlayer().getUniqueId());
        if (hook != null) {
            hook.stopScoreboard();
            this.rsa.getPlayerManagerAPI().getPlayerMap().remove(hook.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void changeWorld(PlayerChangedWorldEvent e) {
        RSBPlayer hook;
        if (RSBConfig.file().getBoolean("Config.World-Scoreboard-Switch").booleanValue() && (hook = this.rsa.getPlayerManagerAPI().getPlayer(e.getPlayer().getUniqueId())) != null) {
            hook.setScoreboard(this.rsa.getScoreboardManagerAPI().getScoreboardForPlayer(e.getPlayer()));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        if (RSBConfig.file().getBoolean("Config.Auto-Hide-In-Vanish").booleanValue()) {
            Player p = e.getPlayer();
            String cmd = e.getMessage().split(" ")[0];
            for (String vanishCommand : RSBConfig.file().getStringList("Config.Vanish-Commands")) {
                if (!cmd.equalsIgnoreCase("/" + vanishCommand)) continue;
                PlayerData playerData = this.rsa.getDatabaseManagerAPI().getPlayerData(p.getUniqueId());
                playerData.setScoreboardON(this.rsa.getPlayerManagerAPI().isVanished(p));
                this.rsa.getDatabaseManagerAPI().savePlayerData(playerData, true);
                break;
            }
        }
    }
}

