/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.managers;

import java.util.Arrays;
import java.util.HashMap;
import joserodpt.realscoreboard.api.animation.TextLooper;
import joserodpt.realscoreboard.api.config.RSBConfig;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class AnimationManagerAPI
extends joserodpt.realscoreboard.api.managers.AnimationManagerAPI {
    private final HashMap<String, TextLooper> loopAnimations = new HashMap();
    private final JavaPlugin plugin;
    private BukkitTask looper;

    public AnimationManagerAPI(JavaPlugin plugin) {
        this.plugin = plugin;
        this.start();
    }

    @Override
    public void start() {
        this.loopAnimations.put("rainbow", new TextLooper("rainbow", Arrays.asList("&c", "&6", "&e", "&a", "&b", "&9", "&3", "&d")));
        this.runLoopers();
    }

    @Override
    public String getLoopAnimation(String s) {
        return this.loopAnimations.containsKey(s) ? this.loopAnimations.get(s).get() : "? not found";
    }

    @Override
    public void stop() {
        this.cancelAnimationTasks();
        this.loopAnimations.clear();
    }

    @Override
    public void cancelAnimationTasks() {
        if (this.looper != null && !this.looper.isCancelled()) {
            this.looper.cancel();
        }
    }

    private void runLoopers() {
        this.looper = new BukkitRunnable(){

            public void run() {
                AnimationManagerAPI.this.loopAnimations.forEach((s, textLooper) -> textLooper.next());
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, (long)RSBConfig.file().getInt("Config.Animations.Loop-Delay").intValue());
    }

    @Override
    public void reload() {
        this.stop();
        this.start();
    }
}

