/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.managers;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.jdbc.db.DatabaseTypeUtils;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.logger.NullLogBackend;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import joserodpt.realscoreboard.api.config.PlayerData;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.events.DataSaveEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;

public class DatabaseManagerAPI
extends joserodpt.realscoreboard.api.managers.DatabaseManagerAPI {
    private final Dao<PlayerData, UUID> playerDataDao;
    private final JavaPlugin javaPlugin;
    private final HashMap<UUID, PlayerData> playerDataCache = new HashMap();
    private final ExecutorService executor;

    public DatabaseManagerAPI(JavaPlugin javaPlugin) throws SQLException {
        LoggerFactory.setLogBackendFactory(new NullLogBackend.NullLogBackendFactory());
        this.javaPlugin = javaPlugin;
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("RealScoreboard-Pool-%d").build());
        String databaseURL = this.getDatabaseURL();
        JdbcConnectionSource connectionSource = new JdbcConnectionSource(databaseURL, RSBConfig.getSql().getString("username"), RSBConfig.getSql().getString("password"), DatabaseTypeUtils.createDatabaseType(databaseURL));
        TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, PlayerData.class);
        this.playerDataDao = DaoManager.createDao((ConnectionSource)connectionSource, PlayerData.class);
        this.getPlayerData();
    }

    private String getDatabaseURL() {
        String driver;
        switch (driver = RSBConfig.getSql().getString("driver").toLowerCase(Locale.ROOT)) {
            case "mysql": 
            case "mariadb": {
                return "jdbc:mysql://" + RSBConfig.getSql().getString("host") + ":" + RSBConfig.getSql().getInt("port") + "/" + RSBConfig.getSql().getString("database");
            }
            case "postgresql": {
                return "jdbc:postgresql://" + RSBConfig.getSql().getString("host") + ":" + RSBConfig.getSql().getInt("port") + "/" + RSBConfig.getSql().getString("database");
            }
            case "sqlserver": {
                return "jdbc:sqlserver://" + RSBConfig.getSql().getString("host") + ":" + RSBConfig.getSql().getInt("port") + ";databaseName=" + RSBConfig.getSql().getString("database");
            }
        }
        return "jdbc:sqlite:" + String.valueOf(new File(this.javaPlugin.getDataFolder(), RSBConfig.getSql().getString("database") + ".db"));
    }

    private void getPlayerData() {
        try {
            this.playerDataDao.queryForAll().forEach(playerData -> this.playerDataCache.put(playerData.getUuid(), (PlayerData)playerData));
        }
        catch (SQLException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public PlayerData getPlayerData(UUID uuid) {
        return this.playerDataCache.getOrDefault(uuid, new PlayerData(uuid));
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.3")
    public void savePlayerData(PlayerData playerData, boolean async) {
        this.playerDataCache.put(playerData.getUuid(), playerData);
        DataSaveEvent event = new DataSaveEvent(playerData, async);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (async) {
            this.saveDataAsync(playerData);
        } else {
            try {
                this.playerDataDao.createOrUpdate(playerData);
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.3")
    private void saveDataAsync(PlayerData playerData) {
        this.executor.execute(() -> {
            try {
                this.playerDataDao.createOrUpdate(playerData);
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        });
    }
}

