/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.conditions.ConditionManager;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.config.RSBScoreboards;
import joserodpt.realscoreboard.api.scoreboard.RBoard;
import joserodpt.realscoreboard.api.scoreboard.RScoreboard;
import joserodpt.realscoreboard.api.scoreboard.RScoreboardBoards;
import joserodpt.realscoreboard.api.scoreboard.RScoreboardSingle;
import org.bukkit.entity.Player;

public class ScoreboardManagerAPI
implements joserodpt.realscoreboard.api.managers.ScoreboardManagerAPI {
    private final Map<String, RScoreboard> scoreboards = new HashMap<String, RScoreboard>();
    private final RealScoreboardAPI rsa;
    private final ConditionManager conditionManager;

    public ScoreboardManagerAPI(RealScoreboardAPI rsa, ConditionManager conditionManager) {
        this.rsa = rsa;
        this.conditionManager = conditionManager;
    }

    @Override
    public void loadScoreboards() {
        if (RSBConfig.file().contains("Config.Scoreboard")) {
            this.rsa.getLogger().warning("Starting scoreboard conversion to the new scoreboards.yml file...");
            this.convertOldScoreboardsV1dot4();
        }
        if (!RSBScoreboards.file().contains("Scoreboards") || RSBScoreboards.file().getSection("Scoreboards") == null) {
            this.rsa.getLogger().severe("There seems to be no valid scoreboards in the scoreboards.yml file!");
            return;
        }
        for (String scoreboardName : RSBScoreboards.file().getSection("Scoreboards").getRoutesAsStrings(false)) {
            if (this.scoreboards.containsKey(scoreboardName)) continue;
            String key2 = "Scoreboards." + scoreboardName + ".";
            String w = RSBScoreboards.file().getString(key2 + "Default-World");
            boolean def = RSBScoreboards.file().getBoolean(key2 + "Default");
            String displayName = RSBScoreboards.file().getString(key2 + "Display-Name");
            String permission = RSBScoreboards.file().getString(key2 + "Permission");
            int titleRefresh = RSBScoreboards.file().getInt(key2 + "Refresh.Title");
            int titleLoopDelay = RSBScoreboards.file().getInt(key2 + "Refresh.Title-Loop-Delay");
            int globalScoreboardRefresh = RSBScoreboards.file().getInt(key2 + "Refresh.Scoreboard");
            List<String> otherWorlds = RSBScoreboards.file().getStringList(key2 + "Other-Worlds");
            if (RSBScoreboards.file().contains(key2 + "Lines")) {
                List<String> title = RSBScoreboards.file().getStringList(key2 + "Title");
                List<String> lines = RSBScoreboards.file().getStringList(key2 + "Lines");
                this.scoreboards.put(scoreboardName, new RScoreboardSingle(scoreboardName, displayName, permission, w, otherWorlds, title, lines, titleRefresh, titleLoopDelay, globalScoreboardRefresh, def));
                continue;
            }
            this.scoreboards.put(scoreboardName, new RScoreboardBoards(scoreboardName, displayName, permission, w, otherWorlds, titleRefresh, titleLoopDelay, globalScoreboardRefresh, RSBScoreboards.file().getInt(key2 + "Refresh.Board-Loop-Delay"), def));
        }
        HashMap<String, Boolean> worldHasDefault = new HashMap<String, Boolean>();
        for (RScoreboard rScoreboard : this.scoreboards.values()) {
            String worldName = rScoreboard.getDefaultWord().toLowerCase();
            worldHasDefault.compute(worldName, (key, hasDefault) -> hasDefault == null ? rScoreboard.isDefault() : hasDefault != false || rScoreboard.isDefault());
        }
        worldHasDefault.forEach((world, hasDefault) -> {
            if (!hasDefault.booleanValue()) {
                this.rsa.getLogger().severe(world + " doesn't have a default scoreboard set!");
            }
        });
        this.scoreboards.values().forEach(RScoreboard::init);
        this.rsa.getLogger().info("Loaded " + this.scoreboards.size() + " scoreboards.");
    }

    private void convertOldScoreboardsV1dot4() {
        int counter = 0;
        for (String world : RSBConfig.file().getSection("Config.Scoreboard").getRoutesAsStrings(false)) {
            for (String permNode : RSBConfig.file().getSection("Config.Scoreboard." + world).getRoutesAsStrings(false)) {
                Object newPermission;
                RSBScoreboards.file().remove("Scoreboards." + permNode);
                String oldScoreboardEntry = "Config.Scoreboard." + world + "." + permNode + ".";
                Object object = newPermission = permNode.equalsIgnoreCase("default") ? "none" : "realscoreboard.scoreboard" + permNode;
                if (RSBConfig.file().getSection(oldScoreboardEntry + "Boards").getRoutesAsStrings(false).size() == 1) {
                    for (String boardName : RSBConfig.file().getSection(oldScoreboardEntry + "Boards").getRoutesAsStrings(false)) {
                        String boardEntry = oldScoreboardEntry + "Boards." + boardName;
                        List<String> title = RSBConfig.file().getStringList(boardEntry + ".Title");
                        List<String> lines = RSBConfig.file().getStringList(boardEntry + ".Lines");
                        this.scoreboards.put(permNode, new RScoreboardSingle(permNode, (String)newPermission, world, Collections.emptyList(), title, lines, RSBConfig.file().getInt("Config.Animations.Title-Delay"), (int)RSBConfig.file().getInt("Config.Animations.Loop-Delay"), (int)RSBConfig.file().getInt("Config.Scoreboard-Refresh"), permNode.equalsIgnoreCase("default"), true));
                        ++counter;
                    }
                } else {
                    ArrayList<RBoard> boards = new ArrayList<RBoard>();
                    RScoreboardBoards rsbb = new RScoreboardBoards(permNode, (String)newPermission, world, Collections.emptyList(), RSBConfig.file().getInt("Config.Animations.Title-Delay"), (int)RSBConfig.file().getInt("Config.Animations.Loop-Delay"), (int)RSBConfig.file().getInt("Config.Scoreboard-Refresh"), (int)RSBConfig.file().getInt(oldScoreboardEntry + "Switch-Timer"), permNode.equalsIgnoreCase("default"));
                    ++counter;
                    for (String boardName : RSBConfig.file().getSection(oldScoreboardEntry + "Boards").getRoutesAsStrings(false)) {
                        String boardEntry = oldScoreboardEntry + "Boards." + boardName;
                        List<String> title = RSBConfig.file().getStringList(boardEntry + ".Title");
                        List<String> lines = RSBConfig.file().getStringList(boardEntry + ".Lines");
                        boards.add(new RBoard(title, lines));
                    }
                    boards.forEach(rBoard -> rBoard.setScoreboard(rsbb));
                    rsbb.setBoards(boards);
                    this.scoreboards.put(permNode, rsbb);
                }
                this.rsa.getLogger().warning("Converted Scoreboard " + permNode);
            }
        }
        this.scoreboards.values().forEach(RScoreboard::init);
        this.rsa.getLogger().warning("Converted " + counter + " scoreboards from the old config format.");
        RSBConfig.file().remove("Config.Scoreboard");
        RSBConfig.save();
    }

    @Override
    public void reload() {
        this.scoreboards.values().forEach(RScoreboard::stopTasks);
        this.scoreboards.clear();
        this.conditionManager.loadConditions();
        this.loadScoreboards();
    }

    @Override
    public Map<String, RScoreboard> getScoreboardMap() {
        return this.scoreboards;
    }

    @Override
    public Collection<RScoreboard> getScoreboards() {
        return this.getScoreboardMap().values();
    }

    @Override
    public RScoreboard getScoreboardForPlayer(Player p) {
        for (RScoreboard sb : this.scoreboards.values()) {
            if (!sb.isInWorld(p.getWorld()) || sb.getPermission().equalsIgnoreCase("none") || !p.hasPermission(sb.getPermission())) continue;
            return sb;
        }
        for (RScoreboard sb : this.scoreboards.values()) {
            if (!sb.isInWorld(p.getWorld()) || !sb.isDefault()) continue;
            return sb;
        }
        return null;
    }

    @Override
    public RScoreboard getScoreboard(String name) {
        return this.getScoreboardMap().get(name);
    }
}

