/*
 * Decompiled with CFR 0.152.
 */
package joserodpt.realscoreboard.utils;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joserodpt.realscoreboard.RealScoreboard;
import joserodpt.realscoreboard.RealScoreboardPlugin;
import joserodpt.realscoreboard.api.RealScoreboardAPI;
import joserodpt.realscoreboard.api.conditions.Condition;
import joserodpt.realscoreboard.api.config.RSBConfig;
import joserodpt.realscoreboard.api.utils.IPlaceholders;
import joserodpt.realscoreboard.api.utils.PingUtil;
import joserodpt.realscoreboard.api.utils.Text;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class Placeholders
implements IPlaceholders {
    private final RealScoreboardAPI rsa;
    DecimalFormat decimalFormat = new DecimalFormat("#.##");

    public Placeholders(RealScoreboardAPI rsa) {
        this.rsa = rsa;
    }

    private String ram() {
        Runtime r = Runtime.getRuntime();
        return (r.totalMemory() - r.freeMemory()) / 0x100000L + "MB";
    }

    private int port() {
        return Bukkit.getPort();
    }

    private String serverIP() {
        return Bukkit.getIp();
    }

    private String time() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(RSBConfig.file().getString("Config.Hours.Formatting"));
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(11, RSBConfig.file().getInt("Config.Hours.Offset"));
        cal.getTime();
        return dateFormat.format(cal.getTime());
    }

    private String day() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(RSBConfig.file().getString("Config.Days.Formatting"));
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(11, RSBConfig.file().getInt("Config.Days.Offset"));
        cal.getTime();
        return dateFormat.format(cal.getTime());
    }

    private String cords(Player player) {
        return "X: " + player.getLocation().getBlockX() + " Y: " + player.getLocation().getBlockY() + " Z: " + player.getLocation().getBlockZ();
    }

    private int onlinePlayers() {
        return Bukkit.getOnlinePlayers().size();
    }

    private int maxPlayers() {
        return Bukkit.getMaxPlayers();
    }

    private String getVersion() {
        return Bukkit.getBukkitVersion();
    }

    private String getWorldName(Player p) {
        return p.getLocation().getWorld().getName();
    }

    private String getGroup(Player p) {
        if (RealScoreboardPlugin.getInstance().getPerms() != null) {
            try {
                String w = RealScoreboardPlugin.getInstance().getPerms().getPrimaryGroup(p);
                if (w == null || w.isEmpty()) {
                    return "None";
                }
                return w;
            }
            catch (UnsupportedOperationException e) {
                return "No Perm Plugin";
            }
        }
        return "Missing Vault";
    }

    private String prefix(Player p) {
        if (RealScoreboardPlugin.getInstance().getChat() != null) {
            String grupo = RealScoreboardPlugin.getInstance().getChat().getPrimaryGroup(p);
            if (grupo == null || grupo.isEmpty()) {
                return "None";
            }
            String prefix = RealScoreboardPlugin.getInstance().getChat().getGroupPrefix(p.getWorld(), grupo);
            if (prefix == null || prefix.isEmpty()) {
                return "None";
            }
            return Text.color(prefix);
        }
        return "Missing Vault";
    }

    private String sufix(Player p) {
        if (RealScoreboardPlugin.getInstance().getChat() != null) {
            String grupo = RealScoreboardPlugin.getInstance().getChat().getPrimaryGroup(p);
            if (grupo == null || grupo.isEmpty()) {
                return "None";
            }
            String sufix = RealScoreboardPlugin.getInstance().getChat().getGroupSuffix(p.getWorld(), grupo);
            if (sufix == null || sufix.isEmpty()) {
                return "None";
            }
            return Text.color(sufix);
        }
        return "Missing Vault";
    }

    private double money(Player p) {
        return RealScoreboardPlugin.getInstance().getEconomy() == null ? -1.0 : RealScoreboardPlugin.getInstance().getEconomy().getBalance((OfflinePlayer)p);
    }

    private int stats(Player p, Statistic s) {
        return p.getStatistic(s);
    }

    private String getKD(Player p) {
        int kills = p.getStatistic(Statistic.PLAYER_KILLS);
        int deaths = p.getStatistic(Statistic.DEATHS);
        if (deaths != 0) {
            double kd = (double)kills / (double)deaths;
            return this.decimalFormat.format(kd);
        }
        return "0";
    }

    private String lifeHeart(long round) {
        if (round <= 5L) {
            return "&c\u2764";
        }
        if (round <= 10L) {
            return "&e\u2764";
        }
        if (round <= 15L) {
            return "&6\u2764";
        }
        if (round <= 20L) {
            return "&a\u2764";
        }
        return "\u2764";
    }

    @Override
    public String setPlaceholders(Player p, String s, boolean skipCond) {
        Pattern pattern = Pattern.compile("%(.*?)%");
        Matcher matcher = pattern.matcher(s);
        block76: while (matcher.find()) {
            String placeholder = matcher.group(1);
            if (!skipCond && placeholder.startsWith("cond:")) {
                String condName = placeholder.substring(5);
                Condition condition = this.rsa.getConditionManager().getCondition(condName);
                if (condition == null) {
                    s = s.replace("%" + placeholder + "%", "&cInvalid condition '" + condName + "'");
                    continue;
                }
                s = s.replace("%" + placeholder + "%", condition.evaluate(p));
                continue;
            }
            switch (placeholder.toLowerCase()) {
                case "playername": {
                    s = s.replace("%" + placeholder + "%", p.getName());
                    continue block76;
                }
                case "loc": {
                    s = s.replace("%" + placeholder + "%", this.cords(p));
                    continue block76;
                }
                case "life": {
                    s = s.replace("%" + placeholder + "%", "" + Math.round(p.getHealth()));
                    continue block76;
                }
                case "lifeheart": {
                    s = s.replace("%" + placeholder + "%", this.lifeHeart(Math.round(p.getHealth())));
                    continue block76;
                }
                case "time": {
                    s = s.replace("%" + placeholder + "%", this.time());
                    continue block76;
                }
                case "day": {
                    s = s.replace("%" + placeholder + "%", this.day());
                    continue block76;
                }
                case "worlddays": {
                    double days = (double)p.getWorld().getFullTime() / 24000.0;
                    double roundedDays = (double)Math.round(days * 10.0) / 10.0;
                    s = s.replace("%" + placeholder + "%", String.valueOf(roundedDays));
                    continue block76;
                }
                case "serverip": {
                    s = s.replace("%" + placeholder + "%", this.serverIP());
                    continue block76;
                }
                case "version": {
                    s = s.replace("%" + placeholder + "%", this.getVersion());
                    continue block76;
                }
                case "versionshort": {
                    s = s.replace("%" + placeholder + "%", this.getVersion());
                    continue block76;
                }
                case "ping": {
                    s = s.replace("%" + placeholder + "%", PingUtil.getPing(p) + " ms");
                    continue block76;
                }
                case "ram": {
                    s = s.replace("%" + placeholder + "%", this.ram());
                    continue block76;
                }
                case "jumps": {
                    s = s.replace("%" + placeholder + "%", "" + this.stats(p, Statistic.JUMP));
                    continue block76;
                }
                case "mobkills": {
                    s = s.replace("%" + placeholder + "%", "" + this.stats(p, Statistic.MOB_KILLS));
                    continue block76;
                }
                case "world": {
                    s = s.replace("%" + placeholder + "%", this.getWorldName(p));
                    continue block76;
                }
                case "port": {
                    s = s.replace("%" + placeholder + "%", String.valueOf(this.port()));
                    continue block76;
                }
                case "maxplayers": {
                    s = s.replace("%" + placeholder + "%", String.valueOf(this.maxPlayers()));
                    continue block76;
                }
                case "online": {
                    s = s.replace("%" + placeholder + "%", String.valueOf(this.onlinePlayers()));
                    continue block76;
                }
                case "prefix": {
                    s = s.replace("%" + placeholder + "%", this.prefix(p));
                    continue block76;
                }
                case "suffix": {
                    s = s.replace("%" + placeholder + "%", this.sufix(p));
                    continue block76;
                }
                case "yaw": {
                    s = s.replace("%" + placeholder + "%", String.valueOf(p.getLocation().getYaw()));
                    continue block76;
                }
                case "kills": {
                    s = s.replace("%" + placeholder + "%", String.valueOf(this.stats(p, Statistic.PLAYER_KILLS)));
                    continue block76;
                }
                case "deaths": {
                    s = s.replace("%" + placeholder + "%", String.valueOf(this.stats(p, Statistic.DEATHS)));
                    continue block76;
                }
                case "kd": {
                    s = s.replace("%" + placeholder + "%", this.getKD(p));
                    continue block76;
                }
                case "pitch": {
                    s = s.replace("%" + placeholder + "%", String.valueOf(p.getLocation().getPitch()));
                    continue block76;
                }
                case "playerfood": {
                    s = s.replace("%" + placeholder + "%", String.valueOf(p.getFoodLevel()));
                    continue block76;
                }
                case "group": {
                    s = s.replace("%" + placeholder + "%", this.getGroup(p));
                    continue block76;
                }
                case "money": {
                    s = s.replace("%" + placeholder + "%", Text.formatMoney(this.money(p)));
                    continue block76;
                }
                case "moneylong": {
                    s = s.replace("%" + placeholder + "%", Text.formatMoneyLong(this.money(p)));
                    continue block76;
                }
                case "displayname": {
                    s = s.replace("%" + placeholder + "%", p.getDisplayName());
                    continue block76;
                }
                case "xp": {
                    s = s.replace("%" + placeholder + "%", "" + p.getTotalExperience());
                    continue block76;
                }
                case "x": {
                    s = s.replace("%" + placeholder + "%", "" + p.getLocation().getBlockX());
                    continue block76;
                }
                case "y": {
                    s = s.replace("%" + placeholder + "%", "" + p.getLocation().getBlockY());
                    continue block76;
                }
                case "z": {
                    s = s.replace("%" + placeholder + "%", "" + p.getLocation().getBlockZ());
                    continue block76;
                }
                case "rainbow": {
                    s = s.replace("%" + placeholder + "%", RealScoreboard.getInstance().getAnimationManagerAPI().getLoopAnimation("rainbow"));
                    continue block76;
                }
                case "playtime": {
                    s = s.replace("%" + placeholder + "%", Text.formatTime(this.stats(p, Statistic.PLAY_ONE_MINUTE) / 20));
                    continue block76;
                }
            }
            s = s.replace("%" + placeholder + "%", this.placeholderAPI(p, "%" + placeholder + "%"));
        }
        return Text.color(s);
    }

    private String placeholderAPI(Player p, String placeholder) {
        try {
            return RealScoreboardPlugin.getInstance().isPlaceholderAPI() ? PlaceholderAPI.setPlaceholders((Player)p, (String)placeholder) : placeholder;
        }
        catch (Exception e) {
            RealScoreboardPlugin.getInstance().getLogger().warning("Error while processing PlaceholderAPI placeholder: " + placeholder);
            RealScoreboardPlugin.getInstance().getLogger().warning(e.getMessage());
            return "ERR " + placeholder;
        }
    }
}

