/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AECheckbox;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEColorPicker;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIconButton;
import net.pedroksl.advanced_ae.common.definitions.AAESlotSemantics;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.AAEColor;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.gui.QuantumArmorStyleConfigMenu;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorStylePacket;

public class QuantumArmorStyleConfigScreen
extends AEBaseScreen<QuantumArmorStyleConfigMenu> {
    private int selectedIndex = -1;
    private boolean applyToAll = true;
    private final AAEColorPicker colorPicker;
    private final AECheckbox checkBox;
    private final ConfirmButton confirmButton;

    public QuantumArmorStyleConfigScreen(QuantumArmorStyleConfigMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        AESubScreen.addBackButton((ISubMenu)menu, (String)"back", (WidgetContainer)this.widgets);
        this.colorPicker = new AAEColorPicker((arg_0, arg_1) -> ((WidgetContainer)this.widgets).add(arg_0, arg_1), 0, style, "colorPicker");
        this.checkBox = this.widgets.addCheckbox("checkBox", (Component)AAEText.ApplyToAll.text(), this::toggleApplyToAll);
        this.confirmButton = new ConfirmButton(value -> this.confirm());
        this.widgets.add("confirmButton", (AbstractWidget)this.confirmButton);
    }

    protected void init() {
        super.init();
        this.selectedIndex = ((QuantumArmorStyleConfigMenu)this.getMenu()).slotIndex;
        int lastColor = -1;
        for (Slot slot : ((QuantumArmorStyleConfigMenu)this.menu).getSlots(AAESlotSemantics.ARMOR)) {
            Item item;
            if (!slot.hasItem() || !((item = slot.getItem().getItem()) instanceof QuantumArmorBase)) continue;
            QuantumArmorBase armor = (QuantumArmorBase)item;
            int color = armor.getTintColor(slot.getItem());
            if (lastColor != -1 && lastColor != color) {
                this.applyToAll = false;
                break;
            }
            lastColor = color;
        }
        this.checkBox.setSelected(this.applyToAll);
        this.updateColorPicker();
    }

    public void toggleApplyToAll() {
        this.applyToAll = !this.applyToAll;
    }

    public void updateColorPicker() {
        Item item;
        Slot slot;
        if (this.selectedIndex != -1 && this.selectedIndex < ((QuantumArmorStyleConfigMenu)this.menu).slots.size() && (slot = ((QuantumArmorStyleConfigMenu)this.menu).getSlot(this.selectedIndex)).hasItem() && (item = slot.getItem().getItem()) instanceof QuantumArmorBase) {
            QuantumArmorBase armor = (QuantumArmorBase)item;
            this.colorPicker.setColorAndUpdate(armor.getTintColor(slot.getItem()));
        }
    }

    public void confirm() {
        ArrayList<Integer> updateList = new ArrayList<Integer>();
        if (this.applyToAll) {
            for (Slot slot : ((QuantumArmorStyleConfigMenu)this.menu).getSlots(AAESlotSemantics.ARMOR)) {
                Item item;
                if (!slot.hasItem() || !((item = slot.getItem().getItem()) instanceof QuantumArmorBase)) continue;
                QuantumArmorBase armor = (QuantumArmorBase)item;
                updateList.add(slot.index);
            }
        } else {
            Item item;
            Slot slot = ((QuantumArmorStyleConfigMenu)this.menu).getSlot(this.selectedIndex);
            if (slot.hasItem() && (item = slot.getItem().getItem()) instanceof QuantumArmorBase) {
                QuantumArmorBase armor = (QuantumArmorBase)item;
                updateList.add(slot.index);
            }
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new QuantumArmorStylePacket(updateList, this.colorPicker.color().argb()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        Slot slot;
        assert (this.minecraft != null);
        if (btn == 0 && this.isValidSlot(slot = this.findSlot(xCoord, yCoord))) {
            if (this.applyToAll) {
                return true;
            }
            this.selectedIndex = slot.index;
            ((QuantumArmorStyleConfigMenu)this.menu).setSelectedItemSlot(slot.getSlotIndex());
            this.updateColorPicker();
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    private boolean isValidSlot(Slot slot) {
        return slot != null && slot.isActive() && slot.hasItem() && slot.getItem().getItem() instanceof QuantumArmorBase;
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        if (this.applyToAll) {
            for (Slot slot : ((QuantumArmorStyleConfigMenu)this.menu).getSlots(AAESlotSemantics.ARMOR)) {
                AEBaseScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(slot.x + offsetX), (int)(slot.y + offsetY), (int)0, (int)AAEColor.LIGHT_PURPLE.argb());
            }
        } else if (this.selectedIndex != -1 && this.selectedIndex < ((QuantumArmorStyleConfigMenu)this.menu).slots.size()) {
            Slot slot = ((QuantumArmorStyleConfigMenu)this.menu).getSlot(this.selectedIndex);
            AEBaseScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(slot.x + offsetX), (int)(slot.y + offsetY), (int)0, (int)AAEColor.LIGHT_PURPLE.argb());
        }
    }

    static class ConfirmButton
    extends AAEIconButton {
        public ConfirmButton(Button.OnPress onPress) {
            super(onPress);
        }

        @Override
        protected AAEIcon getIcon() {
            return AAEIcon.CONFIRM;
        }
    }
}

