/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ConfirmableTextField;
import java.util.ArrayList;
import java.util.HexFormat;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.MutableComponent;
import net.pedroksl.advanced_ae.common.definitions.AAEText;

public class AAEHexColorInput
extends ConfirmableTextField {
    private final HexFormat hexFormat = HexFormat.of();

    public AAEHexColorInput(ScreenStyle style, Font fontRenderer, int x, int y, int width, int height, Consumer<Integer> onConfirm) {
        super(style, fontRenderer, x, y, width, height);
        this.setBordered(false);
        this.setMaxLength(7);
        this.setTextColor(0xFFFFFF);
        this.setSelectionColor(-16777088);
        this.setVisible(true);
        this.setResponder(text -> this.validate());
        this.setOnConfirm(() -> {
            OptionalInt opt = this.getIntValue();
            if (opt.isPresent()) {
                onConfirm.accept(opt.getAsInt());
            }
        });
        this.validate();
    }

    public OptionalInt getIntValue() {
        String value = this.getValue();
        if (value.startsWith("#")) {
            value = value.substring(1);
        }
        try {
            int intValue = Integer.parseInt(value, 16);
            return OptionalInt.of(intValue);
        }
        catch (NumberFormatException exception) {
            return OptionalInt.empty();
        }
    }

    public void setColor(int color) {
        this.setValue(this.hexFormat.toHexDigits(color).substring(2));
    }

    private void validate() {
        ArrayList<MutableComponent> validation = new ArrayList<MutableComponent>();
        if (this.getIntValue().isEmpty()) {
            validation.add(AAEText.InvalidHexInput.text());
        }
        this.setTooltipMessage(validation);
    }
}

