/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.definitions;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AAEConfig {
    private final ClientConfig client = new ClientConfig();
    private final CommonConfig common = new CommonConfig();
    private static AAEConfig INSTANCE;

    AAEConfig(ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)this.client.spec);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)this.common.spec);
    }

    public boolean getEnableEffects() {
        return (Boolean)this.client.enableEffects.get();
    }

    public int getQuantumComputerMaxSize() {
        return (Integer)this.common.quantumComputerMaxSize.get();
    }

    public int getQuantumComputerAcceleratorThreads() {
        return (Integer)this.common.quantumComputerAcceleratorThreads.get();
    }

    public int getQuantumComputerMaxMultiThreaders() {
        return (Integer)this.common.quantumComputerMaxMultiThreaders.get();
    }

    public int getQuantumComputermaxDataEntanglers() {
        return (Integer)this.common.quantumComputerMaxDataEntanglers.get();
    }

    public int getQuantumComputerMultiThreaderMultiplication() {
        return (Integer)this.common.quantumComputerMultiThreaderMultiplication.get();
    }

    public int getQuantumComputerDataEntanglerMultiplication() {
        return (Integer)this.common.quantumComputerDataEntanglerMultiplication.get();
    }

    public int getMaxWalkSpeed() {
        return (Integer)this.common.maxWalkSpeed.get();
    }

    public int getMaxSprintSpeed() {
        return (Integer)this.common.maxSprintSpeed.get();
    }

    public int getMaxStepHeight() {
        return (Integer)this.common.maxStepHeight.get();
    }

    public int getMaxJumpHeight() {
        return (Integer)this.common.maxJumpHeight.get();
    }

    public int getmaxHpBuffer() {
        return (Integer)this.common.hpBufferHearts.get();
    }

    public int getMaxFlightSpeed() {
        return (Integer)this.common.maxFlightSpeed.get();
    }

    public int getEvasionChance() {
        return (Integer)this.common.evasionChance.get();
    }

    public int getMaxMagnetRange() {
        return (Integer)this.common.maxMagnetRange.get();
    }

    public int getStrengthBoost() {
        return (Integer)this.common.strengthBoost.get();
    }

    public int getAttackSpeedBoost() {
        return (Integer)this.common.attackSpeedBoost.get();
    }

    public int getLuckBoost() {
        return (Integer)this.common.luckBoost.get();
    }

    public int getMaxReachBoost() {
        return (Integer)this.common.maxReachBoost.get();
    }

    public int getMaxSwimSpeedBoost() {
        return (Integer)this.common.swimSpeedBoost.get();
    }

    public int getRenegerationPerTick() {
        return (Integer)this.common.regenerationPerTick.get();
    }

    public int getPercentageDamageAbsorption() {
        return (Integer)this.common.percentageDamageAbsorption.get();
    }

    public int getThroughputMonitorCacheSize() {
        return (Integer)this.common.throughputMonitorCacheSize.get();
    }

    public void save() {
        this.common.spec.save();
        this.client.spec.save();
    }

    public static void register(ModContainer container) {
        if (!container.getModId().equals("advanced_ae")) {
            throw new IllegalArgumentException();
        }
        INSTANCE = new AAEConfig(container);
    }

    public static AAEConfig instance() {
        return INSTANCE;
    }

    private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, String comment) {
        builder.comment(comment);
        return AAEConfig.define(builder, name, defaultValue);
    }

    private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        builder.comment(comment);
        return AAEConfig.define(builder, name, defaultValue, min, max);
    }

    private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max) {
        return builder.defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.IntValue define(ModConfigSpec.Builder builder, String name, int defaultValue) {
        return AAEConfig.define(builder, name, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static ModConfigSpec.BooleanValue define(ModConfigSpec.Builder builder, String name, boolean defaultValue) {
        return builder.define(name, defaultValue);
    }

    private static class ClientConfig {
        private final ModConfigSpec spec;
        public final ModConfigSpec.BooleanValue enableEffects;

        public ClientConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            builder.push("quantum computer");
            this.enableEffects = AAEConfig.define(builder, "enableEffects", true);
            this.spec = builder.build();
        }
    }

    private static class CommonConfig {
        private final ModConfigSpec spec;
        public final ModConfigSpec.IntValue quantumComputerMaxSize;
        public final ModConfigSpec.IntValue quantumComputerAcceleratorThreads;
        public final ModConfigSpec.IntValue quantumComputerMaxMultiThreaders;
        public final ModConfigSpec.IntValue quantumComputerMaxDataEntanglers;
        public final ModConfigSpec.IntValue quantumComputerMultiThreaderMultiplication;
        public final ModConfigSpec.IntValue quantumComputerDataEntanglerMultiplication;
        public final ModConfigSpec.IntValue maxWalkSpeed;
        public final ModConfigSpec.IntValue maxSprintSpeed;
        public final ModConfigSpec.IntValue maxStepHeight;
        public final ModConfigSpec.IntValue maxJumpHeight;
        public final ModConfigSpec.IntValue hpBufferHearts;
        public final ModConfigSpec.IntValue maxFlightSpeed;
        public final ModConfigSpec.IntValue evasionChance;
        public final ModConfigSpec.IntValue maxMagnetRange;
        public final ModConfigSpec.IntValue strengthBoost;
        public final ModConfigSpec.IntValue attackSpeedBoost;
        public final ModConfigSpec.IntValue luckBoost;
        public final ModConfigSpec.IntValue maxReachBoost;
        public final ModConfigSpec.IntValue swimSpeedBoost;
        public final ModConfigSpec.IntValue regenerationPerTick;
        public final ModConfigSpec.IntValue percentageDamageAbsorption;
        public final ModConfigSpec.IntValue throughputMonitorCacheSize;

        public CommonConfig() {
            ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
            builder.push("quantum computer");
            this.quantumComputerMaxSize = AAEConfig.define(builder, "quantumComputerMaxSize", 7, 5, 12, "Define the maximum dimensions of the Quantum Computer Multiblock.");
            this.quantumComputerAcceleratorThreads = AAEConfig.define(builder, "quantumComputerAcceleratorThreads", 8, 4, 16, "Define the amount of Threads per Quantum Computer Accelerator.");
            this.quantumComputerMaxMultiThreaders = AAEConfig.define(builder, "quantumComputerMaxMultiThreaders", 1, 1, 2, "Define the maximum amount of Multi Threaders per Quantum Computer Multiblock.");
            this.quantumComputerMaxDataEntanglers = AAEConfig.define(builder, "quantumComputermaxDataEntanglers", 1, 1, 2, "Define the maximum amount of Data Entanglers per Quantum Computer Multiblock.");
            this.quantumComputerMultiThreaderMultiplication = AAEConfig.define(builder, "quantumComputerMultiThreaderMultiplication", 4, 2, 8, "Define the multiplication factor of the multi threaders.");
            this.quantumComputerDataEntanglerMultiplication = AAEConfig.define(builder, "quantumComputerDataEntanglerMultiplication", 4, 2, 8, "Define the multiplication factor of the data entanglers.");
            builder.pop();
            builder.push("quantum armor");
            this.maxWalkSpeed = AAEConfig.define(builder, "quantumArmorMaxWalkSpeed", 60, 10, 100, "Define the maximum walk speed increase. Values are divided by 10 before use.");
            this.maxSprintSpeed = AAEConfig.define(builder, "quantumArmorMaxSprintSpeed", 80, 10, 150, "Define the maximum sprint speed increase. Values are divided by 10 before use.");
            this.maxStepHeight = AAEConfig.define(builder, "quantumArmorMaxStepHeight", 3, 1, 5, "Define the maximum increase in step height.");
            this.maxJumpHeight = AAEConfig.define(builder, "quantumArmorMaxJumpHeight", 3, 1, 5, "Define the maximum increase in jump height.");
            this.swimSpeedBoost = AAEConfig.define(builder, "quantumArmorSwimSpeedBoost", 80, 10, 150, "Define the maximum swim speed increase. Values are divided by 10 before use.");
            this.hpBufferHearts = AAEConfig.define(builder, "quantumArmorHpBuffer", 20, 5, 50, "Define the HP increased of the HP Buffer card.");
            this.maxFlightSpeed = AAEConfig.define(builder, "quantumArmorMaxFlightSpeed", 10, 1, 15, "Define the maximum speed boost of the Flight Card.");
            this.evasionChance = AAEConfig.define(builder, "quantumArmorEvasionChance", 30, 0, 100, "Define the evasion % chance of the evasion card.");
            this.maxMagnetRange = AAEConfig.define(builder, "quantumArmorMagnetRange", 12, 5, 15, "Define the max range of the magnet card.");
            this.strengthBoost = AAEConfig.define(builder, "quantumArmorStrengthBoost", 10, 5, 50, "Define the Attack Damage boost of the Strength Card.");
            this.attackSpeedBoost = AAEConfig.define(builder, "quantumArmorAttackSpeedBoost", 5, 1, 10, "Define the Attack Speed Damage boost of the Attack Speed Card.");
            this.luckBoost = AAEConfig.define(builder, "quantumArmorLuckBoost", 2, 1, 5, "Define the luck boost of the Luck Card.");
            this.maxReachBoost = AAEConfig.define(builder, "quantumArmorMaxReachBoost", 5, 1, 8, "Define the max additional reach of the Reach Card.");
            this.regenerationPerTick = AAEConfig.define(builder, "quantumArmorRenegerationPerTick", 10, 1, 20, "Define the amount of hearts regenerated per tick with the Regeneration Card. Value will be divided by 10 before use.");
            this.percentageDamageAbsorption = AAEConfig.define(builder, "quantumArmorPercentageDamageAbsorption", 30, 5, 100, "Define the maximum percentage of incoming damage absorbed by the Quantum Armor. This value is still limited by the energy buffer in the equipment.");
            builder.pop();
            builder.push("Miscellaneous");
            this.throughputMonitorCacheSize = AAEConfig.define(builder, "throughputMonitorCacheSize", 80, 40, 400, "Define the size of the cache for the Throughput Monitor. Only affects \"Per minute\" and \"Per 10 minutes\" configurations. Higher values will increase precison, but will make the monitor react slower to changes.");
            builder.pop();
            this.spec = builder.build();
        }
    }
}

