/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.stacks.AEKey;
import appeng.core.network.ClientboundPacket;
import appeng.core.network.CustomAppEngPayload;
import com.mojang.datafixers.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterConfigPatternScreen;

public record PatternConfigServerUpdatePacket(LinkedHashMap<AEKey, Long> inputs, Pair<AEKey, Long> output) implements ClientboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, PatternConfigServerUpdatePacket> STREAM_CODEC = StreamCodec.ofMember(PatternConfigServerUpdatePacket::write, PatternConfigServerUpdatePacket::decode);
    public static final CustomPacketPayload.Type<PatternConfigServerUpdatePacket> TYPE = CustomAppEngPayload.createType((String)"aae_crafter_pattern_update");

    public PatternConfigServerUpdatePacket(LinkedHashMap<AEKey, Long> inputs, Pair<AEKey, Long> output) {
        this.inputs = (LinkedHashMap)inputs.clone();
        this.output = new Pair((Object)((AEKey)output.getFirst()), (Object)((Long)output.getSecond()));
    }

    public CustomPacketPayload.Type<PatternConfigServerUpdatePacket> type() {
        return TYPE;
    }

    public static PatternConfigServerUpdatePacket decode(RegistryFriendlyByteBuf stream) {
        LinkedHashMap<AEKey, Long> inputs = new LinkedHashMap<AEKey, Long>();
        int size = stream.readInt();
        for (int x = 0; x < size; ++x) {
            AEKey key = AEKey.readKey((RegistryFriendlyByteBuf)stream);
            inputs.put(key, stream.readLong());
        }
        AEKey key = AEKey.readKey((RegistryFriendlyByteBuf)stream);
        Pair output = new Pair((Object)key, (Object)stream.readLong());
        return new PatternConfigServerUpdatePacket(inputs, (Pair<AEKey, Long>)output);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeInt(this.inputs.size());
        for (Map.Entry<AEKey, Long> entry : this.inputs.entrySet()) {
            AEKey.writeKey((RegistryFriendlyByteBuf)data, (AEKey)entry.getKey());
            data.writeLong(entry.getValue().longValue());
        }
        AEKey.writeKey((RegistryFriendlyByteBuf)data, (AEKey)((AEKey)this.output.getFirst()));
        data.writeLong(((Long)this.output.getSecond()).longValue());
    }

    public void handleOnClient(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof QuantumCrafterConfigPatternScreen) {
            QuantumCrafterConfigPatternScreen screen2 = (QuantumCrafterConfigPatternScreen)screen;
            screen2.update(this.inputs, this.output);
        }
    }
}

