/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.helpers.AAEColor;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class QuantumArmorRenderer
extends GeoArmorRenderer<QuantumArmorBase> {
    public static final String HUD_BONE = "hud";
    public static final String LEFT_BLADE_BONE = "blade_left";
    public static final String RIGHT_BLADE_BONE = "blade_right";
    public static final String FACE_SHIELD_BONE = "face_shield";
    public static final String RIGHT_ARM = "armorRightArm";
    public static final String LEFT_ARM = "armorLeftArm";
    private final QuantumArmorTintLayer tintLayer = new QuantumArmorTintLayer(this);

    public QuantumArmorRenderer() {
        super((GeoModel)new DefaultedItemGeoModel(AdvancedAE.makeId("quantum_armor")));
        this.addRenderLayer((GeoRenderLayer)this.tintLayer);
    }

    public void setBoneVisible(String boneName, boolean visible) {
        this.getGeoModel().getBone(boneName).ifPresent(geoBone -> geoBone.setHidden(!visible));
    }

    public void setTintColor(int color) {
        this.tintLayer.tintColor = color;
    }

    private static class QuantumArmorTintLayer
    extends AutoGlowingGeoLayer<QuantumArmorBase> {
        private final ResourceLocation TINT_TEXTURE = AdvancedAE.makeId("textures/item/quantum_armor_tint.png");
        private int tintColor = AAEColor.PURPLE.argb();

        public QuantumArmorTintLayer(GeoArmorRenderer<QuantumArmorBase> armorRenderer) {
            super(armorRenderer);
        }

        public void render(PoseStack poseStack, QuantumArmorBase animatable, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            RenderType render = RenderType.entityCutout((ResourceLocation)this.TINT_TEXTURE);
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, render, bufferSource.getBuffer(render), partialTick, packedLight, packedOverlay, this.tintColor);
            renderType = this.getRenderType((GeoAnimatable)animatable, bufferSource);
            if (renderType != null) {
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)animatable, renderType, bufferSource.getBuffer(renderType), partialTick, 0xF00000, packedOverlay, this.tintColor);
            }
        }

        protected ResourceLocation getTextureResource(QuantumArmorBase animatable) {
            return this.TINT_TEXTURE;
        }
    }
}

