/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.events;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.armors.QuantumBoots;
import net.pedroksl.advanced_ae.common.items.armors.QuantumChestplate;
import net.pedroksl.advanced_ae.common.items.armors.QuantumHelmet;
import net.pedroksl.advanced_ae.common.items.armors.QuantumLeggings;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.network.packet.ItemTrackingPacket;
import net.pedroksl.advanced_ae.network.packet.KeysPressedPacket;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.apoth.ApoEnchPlugin;

public class AAEPlayerEvents {
    public static final AttributeModifier flight = new AttributeModifier(AdvancedAE.makeId("flight"), 1.0, AttributeModifier.Operation.ADD_VALUE);
    public static final String NO_KEY_DATA = "aae$nokey";
    public static final String UP_KEY_DATA = "aae$upkey";
    public static final String DOWN_KEY_DATA = "aae$downkey";

    @SubscribeEvent
    public static void ItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.getItem();
        if (item instanceof QuantumArmorBase) {
            QuantumArmorBase armor = (QuantumArmorBase)item;
            if (armor.isUpgradeEnabledAndPowered(itemStack, UpgradeType.STEP_ASSIST)) {
                int value = (Integer)itemStack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.STEP_ASSIST), (Object)0);
                event.addModifier(Attributes.STEP_HEIGHT, AAEPlayerEvents.getStepAssist(value), EquipmentSlotGroup.FEET);
            }
            if (armor.isUpgradeEnabledAndPowered(itemStack, UpgradeType.FLIGHT)) {
                event.addModifier(NeoForgeMod.CREATIVE_FLIGHT, flight, EquipmentSlotGroup.CHEST);
            }
            if (armor.isUpgradeEnabledAndPowered(itemStack, UpgradeType.HP_BUFFER)) {
                int value = (Integer)itemStack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.HP_BUFFER), (Object)0);
                event.addModifier(Attributes.MAX_HEALTH, AAEPlayerEvents.getHpBuffer(value), EquipmentSlotGroup.CHEST);
            }
            if (armor.isUpgradeEnabledAndPowered(itemStack, UpgradeType.STRENGTH)) {
                int value = (Integer)itemStack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.STRENGTH), (Object)0);
                event.addModifier(Attributes.ATTACK_DAMAGE, AAEPlayerEvents.getStrengthBoost(value), EquipmentSlotGroup.CHEST);
            }
            if (armor.isUpgradeEnabledAndPowered(itemStack, UpgradeType.ATTACK_SPEED)) {
                int value = (Integer)itemStack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.ATTACK_SPEED), (Object)0);
                event.addModifier(Attributes.ATTACK_SPEED, AAEPlayerEvents.getAttackSpeedBoost(value), EquipmentSlotGroup.CHEST);
            }
            if (armor.isUpgradeEnabledAndPowered(itemStack, UpgradeType.LUCK)) {
                int value = (Integer)itemStack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.LUCK), (Object)0);
                event.addModifier(Attributes.LUCK, AAEPlayerEvents.getLuckBoost(value), EquipmentSlotGroup.HEAD);
            }
            if (armor.isUpgradeEnabledAndPowered(itemStack, UpgradeType.REACH)) {
                int value = (Integer)itemStack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.REACH), (Object)0);
                AttributeModifier attValue = AAEPlayerEvents.getReachBoost(value);
                event.addModifier(Attributes.BLOCK_INTERACTION_RANGE, attValue, EquipmentSlotGroup.LEGS);
                event.addModifier(Attributes.ENTITY_INTERACTION_RANGE, attValue, EquipmentSlotGroup.LEGS);
            }
        }
    }

    @SubscribeEvent
    public static void BreakSpeed(PlayerEvent.BreakSpeed event) {
        float value;
        AttributeInstance att;
        ItemStack armor;
        Player player = event.getEntity();
        if (!player.onGround()) {
            ItemStack armor2;
            if (!(Addons.APOTHIC_ENCHANTING.isLoaded() && ApoEnchPlugin.checkForEnchant(player, ApoEnchPlugin.Enchantment.STABLE_FOOTING) || !((armor2 = player.getItemBySlot(EquipmentSlot.CHEST)).getItem() instanceof QuantumChestplate))) {
                float newValue = Math.min(Float.MAX_VALUE, event.getOriginalSpeed() * 5.0f);
                event.setNewSpeed(newValue);
            }
        } else if (player.isEyeInFluid(FluidTags.WATER) && (armor = player.getItemBySlot(EquipmentSlot.CHEST)).getItem() instanceof QuantumChestplate && (att = player.getAttribute(Attributes.SUBMERGED_MINING_SPEED)) != null && (value = (float)att.getValue()) < 1.0f) {
            event.setNewSpeed(event.getOriginalSpeed() / value);
        }
    }

    @SubscribeEvent
    public static void playerRender(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            QuantumLeggings item;
            QuantumChestplate item2;
            ItemStack chestStack;
            Item item3;
            QuantumHelmet item4;
            PlayerRenderer renderer = event.getRenderer();
            PlayerModel model = (PlayerModel)renderer.getModel();
            ItemStack helmetStack = player.getItemBySlot(EquipmentSlot.HEAD);
            Item item5 = helmetStack.getItem();
            if (item5 instanceof QuantumHelmet && (item4 = (QuantumHelmet)item5).isVisible(helmetStack)) {
                model.hat.visible = false;
            }
            if ((item3 = (chestStack = player.getItemBySlot(EquipmentSlot.CHEST)).getItem()) instanceof QuantumChestplate && (item2 = (QuantumChestplate)item3).isVisible(chestStack)) {
                model.leftSleeve.visible = false;
                model.rightSleeve.visible = false;
                model.jacket.visible = false;
                model.leftArm.visible = false;
                model.rightArm.visible = false;
            }
            ItemStack leggingsStack = player.getItemBySlot(EquipmentSlot.LEGS);
            ItemStack bootsStack = player.getItemBySlot(EquipmentSlot.FEET);
            Item item6 = leggingsStack.getItem();
            if (item6 instanceof QuantumLeggings && (item = (QuantumLeggings)item6).isVisible(leggingsStack)) {
                QuantumBoots item22;
                model.leftPants.visible = false;
                model.rightPants.visible = false;
                Item item7 = bootsStack.getItem();
                if (item7 instanceof QuantumBoots && (item22 = (QuantumBoots)item7).isVisible(bootsStack)) {
                    model.leftLeg.visible = false;
                    model.rightLeg.visible = false;
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Pre event) {
        ItemStack chestStack;
        Item item;
        boolean downKey;
        boolean upKey;
        ItemStack bootStack;
        Item item2;
        Player player = event.getEntity();
        MobEffectInstance nv = player.getEffect(MobEffects.NIGHT_VISION);
        ItemStack stack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (!stack.isEmpty()) {
            QuantumHelmet helmet;
            Item item3 = stack.getItem();
            if (item3 instanceof QuantumHelmet && (helmet = (QuantumHelmet)item3).isUpgradeEnabledAndPowered(stack, UpgradeType.NIGHT_VISION) && (nv == null || nv.getDuration() < 210)) {
                stack.set(AAEComponents.NIGHT_VISION_ACTIVATED, (Object)true);
                player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 210, 0, false, false, false));
                helmet.consumeEnergy(player, stack, UpgradeType.NIGHT_VISION);
            }
            if (((Boolean)stack.getOrDefault(AAEComponents.NIGHT_VISION_ACTIVATED, (Object)false)).booleanValue() && nv != null && nv.getDuration() < 210) {
                player.removeEffect(MobEffects.NIGHT_VISION);
                stack.remove(AAEComponents.NIGHT_VISION_ACTIVATED);
            }
        }
        if ((item2 = (bootStack = player.getItemBySlot(EquipmentSlot.FEET)).getItem()) instanceof QuantumBoots) {
            QuantumBoots boots = (QuantumBoots)item2;
            if (player.getAbilities().flying && boots.isUpgradeEnabledAndPowered(bootStack, UpgradeType.FLIGHT_DRIFT) && player.getPersistentData().getBoolean(NO_KEY_DATA)) {
                Vec3 motion = player.getDeltaMovement();
                if (motion.x != 0.0 || motion.z != 0.0) {
                    float value = (float)((Integer)bootStack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)UpgradeType.FLIGHT_DRIFT), (Object)100)).intValue() / 100.0f;
                    player.setDeltaMovement(motion.x * (double)value, motion.y, motion.z * (double)value);
                    boots.consumeEnergy(player, bootStack, UpgradeType.FLIGHT_DRIFT);
                }
            }
        }
        if ((upKey = player.getPersistentData().getBoolean(UP_KEY_DATA)) != (downKey = player.getPersistentData().getBoolean(DOWN_KEY_DATA)) && (item = (chestStack = player.getItemBySlot(EquipmentSlot.CHEST)).getItem()) instanceof QuantumChestplate) {
            QuantumChestplate chest = (QuantumChestplate)item;
            UpgradeType upgrade = UpgradeType.FLIGHT;
            if (player.getAbilities().flying && chest.isUpgradeEnabledAndPowered(chestStack, upgrade)) {
                float value = upgrade.getSettings().multiplier * (float)((Integer)chestStack.getOrDefault(AAEComponents.UPGRADE_VALUE.get((Object)upgrade), (Object)0)).intValue() / 25.0f;
                int direction = upKey ? 1 : -1;
                player.moveRelative(value, new Vec3(0.0, (double)direction, 0.0));
            }
        }
    }

    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            ItemStack chestStack;
            Options options;
            QuantumBoots boots;
            ItemStack bootStack = player.getItemBySlot(EquipmentSlot.FEET);
            Item item = bootStack.getItem();
            if (item instanceof QuantumBoots && (boots = (QuantumBoots)item).isUpgradeEnabledAndPowered(bootStack, UpgradeType.FLIGHT_DRIFT)) {
                boolean noKey;
                options = Minecraft.getInstance().options;
                boolean bl = noKey = !options.keyUp.isDown() && !options.keyRight.isDown() && !options.keyDown.isDown() && !options.keyLeft.isDown();
                if (player.getPersistentData().getBoolean(NO_KEY_DATA) != noKey) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new KeysPressedPacket(NO_KEY_DATA, noKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.getPersistentData().putBoolean(NO_KEY_DATA, noKey);
                }
            }
            if ((chestStack = player.getItemBySlot(EquipmentSlot.CHEST)).getItem() instanceof QuantumChestplate) {
                options = Minecraft.getInstance().options;
                boolean downKey = options.keyShift.isDown();
                if (player.getPersistentData().getBoolean(DOWN_KEY_DATA) != downKey) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new KeysPressedPacket(DOWN_KEY_DATA, downKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.getPersistentData().putBoolean(DOWN_KEY_DATA, downKey);
                }
                boolean upKey = options.keyJump.isDown();
                if (player.getPersistentData().getBoolean(UP_KEY_DATA) != upKey) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new KeysPressedPacket(UP_KEY_DATA, upKey), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    player.getPersistentData().putBoolean(UP_KEY_DATA, upKey);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)player;
                if (((ItemEntity)event.getTarget()).thrower != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ItemTrackingPacket(item.thrower, item.getId(), item.pickupDelay), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    private static AttributeModifier getStepAssist(int value) {
        return new AttributeModifier(AdvancedAE.makeId("step_assist"), (double)value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier getHpBuffer(int value) {
        return new AttributeModifier(AdvancedAE.makeId("hp_buffer"), (double)value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier getStrengthBoost(int value) {
        return new AttributeModifier(AdvancedAE.makeId("strength_boost"), (double)value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier getAttackSpeedBoost(int value) {
        return new AttributeModifier(AdvancedAE.makeId("attack_speed"), (double)value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier getLuckBoost(int value) {
        return new AttributeModifier(AdvancedAE.makeId("luck"), (double)value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static AttributeModifier getReachBoost(int value) {
        return new AttributeModifier(AdvancedAE.makeId("reach_boost"), (double)value, AttributeModifier.Operation.ADD_VALUE);
    }
}

