/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import appeng.api.config.CopyMode;
import appeng.api.config.Settings;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.IConfigManager;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.util.ConfigInventory;
import appeng.util.ConfigManager;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.helpers.PortableCellWorkbenchMenuHost;

public class PortableCellWorkbench
implements InternalInventoryHost {
    private final AppEngInternalInventory cell = new AppEngInternalInventory((InternalInventoryHost)this, 1);
    private final ConfigManager manager = new ConfigManager(this::saveChanges);
    private IUpgradeInventory cacheUpgrades = null;
    private ConfigInventory cacheConfig = null;
    private boolean locked = false;
    private final PortableCellWorkbenchMenuHost host;

    public PortableCellWorkbench(PortableCellWorkbenchMenuHost host) {
        this.host = host;
    }

    public ICellWorkbenchItem getCell() {
        if (this.cell.getStackInSlot(0).isEmpty()) {
            return null;
        }
        if (this.cell.getStackInSlot(0).getItem() instanceof ICellWorkbenchItem) {
            return (ICellWorkbenchItem)this.cell.getStackInSlot(0).getItem();
        }
        return null;
    }

    public void saveAdditional(CompoundTag data, HolderLookup.Provider registries) {
        this.cell.writeToNBT(data, "cell", registries);
        this.host.getConfig().writeToChildTag(data, "config", registries);
        this.manager.writeToNBT(data, registries);
    }

    public void loadTag(CompoundTag data, HolderLookup.Provider registries) {
        this.cell.readFromNBT(data, "cell", registries);
        this.host.getConfig().readFromChildTag(data, "config", registries);
        this.manager.readFromNBT(data, registries);
    }

    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.CELLS)) {
            return this.cell;
        }
        return null;
    }

    public void saveChangedInventory(AppEngInternalInventory inv) {
        this.saveChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        if (inv == this.cell && !this.locked) {
            this.locked = true;
            try {
                this.cacheUpgrades = null;
                this.cacheConfig = null;
                ConfigInventory configInventory = this.getCellConfigInventory();
                if (configInventory != null) {
                    if (!configInventory.isEmpty()) {
                        PortableCellWorkbench.copy((GenericStackInv)configInventory, this.host.getConfig());
                    } else {
                        PortableCellWorkbench.copy(this.host.getConfig(), (GenericStackInv)configInventory);
                        PortableCellWorkbench.copy((GenericStackInv)configInventory, this.host.getConfig());
                    }
                } else if (this.manager.getSetting(Settings.COPY_MODE) == CopyMode.CLEAR_ON_REMOVE) {
                    this.host.getConfig().clear();
                    this.saveChanges();
                }
            }
            finally {
                this.locked = false;
            }
        }
    }

    public boolean isClientSide() {
        return this.host.isClientSide();
    }

    public void saveChanges() {
    }

    public void configChanged() {
        if (this.locked) {
            return;
        }
        this.locked = true;
        try {
            ConfigInventory c = this.getCellConfigInventory();
            if (c != null) {
                PortableCellWorkbench.copy(this.host.getConfig(), (GenericStackInv)c);
                PortableCellWorkbench.copy((GenericStackInv)c, this.host.getConfig());
            }
        }
        finally {
            this.locked = false;
        }
    }

    public static void copy(GenericStackInv from, GenericStackInv to) {
        int i;
        for (i = 0; i < Math.min(from.size(), to.size()); ++i) {
            GenericStack fromStack = from.getStack(i);
            if (fromStack != null && !to.isAllowedIn(i, fromStack.what())) {
                fromStack = null;
            }
            to.setStack(i, fromStack);
        }
        for (i = from.size(); i < to.size(); ++i) {
            to.setStack(i, null);
        }
    }

    private ConfigInventory getCellConfigInventory() {
        if (this.cacheConfig == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return null;
            }
            ItemStack is = this.cell.getStackInSlot(0);
            if (is.isEmpty()) {
                return null;
            }
            ConfigInventory inv = cell.getConfigInventory(is);
            if (inv == null) {
                return null;
            }
            this.cacheConfig = inv;
        }
        return this.cacheConfig;
    }

    public IConfigManager getConfigManager() {
        return this.manager;
    }

    public IUpgradeInventory getUpgrades() {
        if (this.cacheUpgrades == null) {
            ICellWorkbenchItem cell = this.getCell();
            if (cell == null) {
                return UpgradeInventories.empty();
            }
            ItemStack is = this.cell.getStackInSlot(0);
            if (is.isEmpty()) {
                return UpgradeInventories.empty();
            }
            IUpgradeInventory inv = cell.getUpgrades(is);
            if (inv == null) {
                return UpgradeInventories.empty();
            }
            this.cacheUpgrades = inv;
            return this.cacheUpgrades;
        }
        return this.cacheUpgrades;
    }
}

