/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae;

import appeng.api.crafting.IPatternDetailsDecoder;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.definitions.AAECreativeTab;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeysRegistry;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.AAENbt;
import net.pedroksl.advanced_ae.common.items.armors.IGridLinkedItem;
import net.pedroksl.advanced_ae.common.patterns.AdvPatternDetailsDecoder;
import net.pedroksl.advanced_ae.events.AAELivingEntityEvents;
import net.pedroksl.advanced_ae.events.AAEPlayerEvents;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.recipes.InitRecipeSerializers;
import net.pedroksl.advanced_ae.recipes.InitRecipeTypes;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.ae2wtlib.AE2WtLibPlugin;
import net.pedroksl.advanced_ae.xmod.appflux.AppliedFluxPlugin;

public class AdvancedAE {
    public static final String MOD_ID = "advanced_ae";
    static AdvancedAE INSTANCE;

    public AdvancedAE() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        AAEConfig.register(MOD_ID);
        AAEItems.INSTANCE.register(eventBus);
        AAEBlocks.INSTANCE.register(eventBus);
        AAEBlockEntities.INSTANCE.register(eventBus);
        AAEFluids.INSTANCE.register(eventBus);
        AAEMenus.INSTANCE.register(eventBus);
        AAECreativeTab.INSTANCE.register(eventBus);
        eventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        eventBus.addListener(AdvancedAE::initUpgrades);
        eventBus.addListener(event -> {
            if (event.getRegistryKey() == Registries.f_256954_) {
                InitRecipeTypes.init(ForgeRegistries.RECIPE_TYPES);
            } else if (event.getRegistryKey() == Registries.f_256764_) {
                InitRecipeSerializers.init(ForgeRegistries.RECIPE_SERIALIZERS);
            } else if (event.getRegistryKey() == Registries.f_256913_) {
                if (Addons.AE2WTLIB.isLoaded()) {
                    AE2WtLibPlugin.commonInit();
                }
            } else if (event.getRegistryKey() == ForgeRegistries.MENU_TYPES && Addons.AE2WTLIB.isLoaded()) {
                AE2WtLibPlugin.initMenu();
            }
        });
        AAEHotkeysRegistry.INSTANCE.init();
        AAENbt.init();
    }

    public static AdvancedAE instance() {
        return INSTANCE;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        if (Addons.AE2WTLIB.isLoaded()) {
            // empty if block
        }
        AAENetworkHandler.INSTANCE.init();
        PatternDetailsHelper.registerDecoder((IPatternDetailsDecoder)AdvPatternDetailsDecoder.INSTANCE);
        AdvancedAE.initGridLinkables();
        AAEPlayerEvents.init();
        AAELivingEntityEvents.init();
    }

    public static void initGridLinkables() {
        GridLinkables.register(AAEItems.QUANTUM_HELMET, (IGridLinkableHandler)IGridLinkedItem.LINKABLE_HANDLER);
        GridLinkables.register(AAEItems.QUANTUM_CHESTPLATE, (IGridLinkableHandler)IGridLinkedItem.LINKABLE_HANDLER);
        GridLinkables.register(AAEItems.QUANTUM_LEGGINGS, (IGridLinkableHandler)IGridLinkedItem.LINKABLE_HANDLER);
        GridLinkables.register(AAEItems.QUANTUM_BOOTS, (IGridLinkableHandler)IGridLinkedItem.LINKABLE_HANDLER);
        if (Addons.AE2WTLIB.isLoaded()) {
            AE2WtLibPlugin.initGridLinkables();
        }
    }

    private static void initUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEBlocks.REACTION_CHAMBER, (int)4);
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEBlocks.QUANTUM_CRAFTER, (int)4);
            Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, AAEBlocks.QUANTUM_CRAFTER, (int)1);
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEItems.STOCK_EXPORT_BUS, (int)4);
            Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, AAEItems.STOCK_EXPORT_BUS, (int)5);
            Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, AAEItems.STOCK_EXPORT_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, AAEItems.STOCK_EXPORT_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, AAEItems.STOCK_EXPORT_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEItems.IMPORT_EXPORT_BUS, (int)4);
            Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, AAEItems.IMPORT_EXPORT_BUS, (int)5);
            Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, AAEItems.IMPORT_EXPORT_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, AAEItems.IMPORT_EXPORT_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, AAEItems.IMPORT_EXPORT_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEItems.ADVANCED_IO_BUS, (int)4);
            Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, AAEItems.ADVANCED_IO_BUS, (int)5);
            Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, AAEItems.ADVANCED_IO_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, AAEItems.ADVANCED_IO_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.FUZZY_CARD, AAEItems.ADVANCED_IO_BUS, (int)1);
            if (Addons.APPFLUX.isLoaded()) {
                AppliedFluxPlugin.init();
            }
            if (Addons.AE2WTLIB.isLoaded()) {
                AE2WtLibPlugin.initUpgrades();
            }
        });
    }

    public static ResourceLocation makeId(String id) {
        return new ResourceLocation(MOD_ID, id);
    }
}

